function run_analysis(handles)

if ~isfield(handles,'loaded_data')
    errordlg('Please load a data file','GEView Error','modal');
    return;
end

initDir=cd;
resultsDir=fileparts(strtrim(get(handles.edit_data_file,'string')));
if exist(resultsDir,'dir')
    initDir=resultsDir;
end

res_path = uigetdir_workaround(initDir,'Select Results Directory');
if ~res_path
    return;
end

% res_path = strtrim(get(handles.edit_results_path,'string'));
% if ~isdir(res_path)
%     errordlg('Results path not found','Path Error','modal');
%     return;
% end

if get(handles.radiobutton_mean,'value')
    mean_median_flag=1;
    mean_median=' (mean fold change)';
else
    mean_median_flag=2;
    mean_median=' (median fold change)';
end

if ispc
    extension='.xlsx';
else
    extension='.xls';
end

out_file=fullfile(res_path,['results_' handles.in_file extension]);
if exist(out_file,'file')
    button1 = questdlg(['Warning: The file ' out_file ' already exists from previous analysis. If you proceed, this file will be deleted ' ...
        'and other result files may be replaced. Would you like to proceed?'], 'Warning: Previous analysis exists','Yes','No','No');
    if strcmp(button1,'No') || isempty(button1)
        return;
    end
    delete(out_file);
    if exist(out_file,'file')
        errordlg(['The file ' out_file ' cannot be deleted. It might be open'],'File Error','modal');
        return;
    end
end

figures_path=fullfile(res_path,'figures','a'); %in order to end with slash for any OS
figures_path(end)=[]; 
if ~exist(figures_path,'dir')
    status=mkdir(figures_path);
    if ~status
        errordlg(['Cannot create folder ' figures_path],'Folder Error','modal');
        return;
    end
end


ids=handles.loaded_data.ids;
gene_symbols=handles.loaded_data.gene_symbols;
groups_cell=handles.loaded_data.sample_labels{1};
samples=handles.loaded_data.samples;
log2_data=handles.loaded_data.log2_data;

if ~isempty(ids)
    idx=find(strcmp(gene_symbols,'---') | strcmp(gene_symbols,''));
    if ~isempty(idx)
        if get(handles.checkbox_only_with_gene_symbols,'value');
            ids(idx)=[];
            gene_symbols(idx)=[];
            log2_data(idx,:)=[];
        else
            gene_symbols(idx)=ids(idx);
        end
    end
end

if length(gene_symbols)>1000
    button1 = questdlg(['Your analysis may take about ' num2str(ceil(length(gene_symbols)/100)) ' minutes. Would you like to proceed?'], 'Time Estimation','Yes','No','No');
    if strcmp(button1,'No') || isempty(button1)
        return;
    end
end

if ~handles.filtering_done
    listbox_sample_numbers=get(handles.listbox_filtered_samples,'userdata');
    if ~isempty(listbox_sample_numbers) %sample filtering
        groups_cell(listbox_sample_numbers)=[];
        samples(listbox_sample_numbers)=[];
        log2_data(:,listbox_sample_numbers)=[];
    end
end

if ishandle(handles.fig_to_delete)
    delete(handles.fig_to_delete);
end 
if ishandle(handles.pca_before_filter_figh)
    delete(handles.pca_before_filter_figh);
end
if ishandle(handles.pca_after_filter_figh)
    delete(handles.pca_after_filter_figh);
end 

sample_grps=unique(groups_cell,'stable');
sample_gr_cell=cell(size(sample_grps));

for i=1:length(sample_grps)
    sample_gr_cell{i}=find(strcmp(sample_grps{i},groups_cell));
end

if ~isempty(find(cellfun('length',sample_gr_cell)==1))
    errordlg('Please make sure that each group has at least 2 samples','GEView Error','modal');
    return;
end

set(handles.edit_results_path,'string',res_path);
set(handles.edit_results_path,'tooltipstring',res_path);

set(handles.edit_status,'string','Running: Calculating p-values ...');
figure(gcbf);   % Changes the focus to the figure so that the editable text box loses focus
drawnow;      % Forces the editable text box to update and fires the callback immediately
[ANOVA_p, ANOVA_Q, mc_fold_change_and_pval, mc_table1_title] = calc_anova_fdr(log2_data, groups_cell);

display_samples_flag=get(handles.popupmenu_display_samples_in_fig,'value');

GEView_plot_and_save_genes_exp_gr(log2_data, ids, gene_symbols, figures_path, ...
    mean_median_flag, sample_gr_cell, sample_grps, samples, ANOVA_p, ANOVA_Q, handles.edit_status, display_samples_flag);

if length(sample_grps)==2
    anova_title='t-test';
else
    anova_title='ANOVA';
end

xls_title={'Gene Symbol' 'Link' 'Link' 'Link' [anova_title ' P-value'] [anova_title ' Q-value (corrected)'] [anova_title ' box plots']};
xls_data=cell(length(gene_symbols),length(xls_title));

if length(sample_grps)==2
    xls_title=[xls_title [sample_grps{1} '/' sample_grps{2} mean_median]];
    log2_data_grp1=log2_data(:,sample_gr_cell{1});
    log2_data_grp2=log2_data(:,sample_gr_cell{2});
    if mean_median_flag==1
        fold_change=2.^(mean(log2_data_grp1,2)-mean(log2_data_grp2,2));
    else
        fold_change=2.^(median(log2_data_grp1,2)-median(log2_data_grp2,2));
    end
    xls_data(:,8)=cellstr(num2str(fold_change,3));
elseif length(sample_grps)>2
    xls_title=[xls_title mc_table1_title];
    xls_data=[xls_data mc_fold_change_and_pval];
end

if ~isempty(ids)
    xls_title=['Probe set ID' xls_title];
    ids_for_ucsc=ids;
    fig_file_names=ids;
else
    ids_for_ucsc=gene_symbols;
    fig_file_names=strcat('fig',strtrim(cellstr(num2str([1:length(gene_symbols)]'))));
end

xls_data(:,1)=gene_symbols;
xls_data(:,2)=strcat('=HYPERLINK("http://www.genecards.org/cgi-bin/carddisp.pl?gene=',gene_symbols,'","GeneCards")');
xls_data(:,3)=strcat('=HYPERLINK("http://genome-euro.ucsc.edu/cgi-bin/hgTracks?position=',ids_for_ucsc,'","UCSC")');
xls_data(:,4)=strcat('=HYPERLINK("http://www.ncbi.nlm.nih.gov/gene/?term=',gene_symbols,'","NCBI")');
xls_data(:,5)=cellstr(num2str(ANOVA_p',2));
xls_data(:,6)=cellstr(num2str(ANOVA_Q',2));
xls_data(:,7)=strcat('=HYPERLINK("file:', figures_path,fig_file_names, '.png","Figure")');

if ~isempty(ids)
    xls_data=[ids xls_data];
end

[~,idx]=sort(ANOVA_Q);
xls_data=xls_data(idx,:);

set(handles.edit_status,'string','Saving Excel File ...');
figure(gcbf);   % Changes the focus to the figure so that the editable text box loses focus
drawnow;      % Forces the editable text box to update and fires the callback immediately

if ispc
    [status,msg]=xlswrite(out_file,[xls_title;xls_data]);
else
    saveCellFile([xls_title;xls_data],out_file);
    status=1;
end

if status
    set(handles.edit_status,'string',['Excel file ' out_file ' was saved']);
    disp('Done');
    %msgbox(['Your run has been finished. The results are summarized in ' out_file],'Run Finished','modal');
    if ispc
        button1 = questdlg(['Your run has been finished. The results are summarized in ' out_file],'Run Finished','OK','Open folder','OK');
        if strcmp(button1,'Open folder')
            dos(['explorer ' res_path]);
        end
    else
        msgbox(['Your run has been finished. The results are summarized in ' out_file],'Run Finished','modal');
    end
else
    set(handles.edit_status,'string','Error: Excel result file was not saved');
    disp([msg.identifier ': ' msg.message]);
    errordlg(['Could not write Excel file, ' msg.identifier ': ' msg.message],'GEView Error','modal');
    return;
end