%function [anova_p, Q_vec, st, t_cell] = calc_anova_fdr(log_data, groups_cell);
function [anova_p, Q_vec, mc_fold_change_and_pval, mc_table1_title] = calc_anova_fdr(log_data, groups_cell);

displayopt = 'off';
num_genes = size(log_data,1);
num_of_groups=length(unique(groups_cell));
if num_of_groups>2
    mc_fold_change_and_pval=cell(num_genes,num_of_groups*(num_of_groups-1));
else
    mc_fold_change_and_pval=[];
end
mc_table1_title=cell(1,size(mc_fold_change_and_pval,2));
anova_p = zeros(1, num_genes);
for i = 1:num_genes
    if mod(i,100)==0
        disp(i);
    end
    [anova_p(i), ~, st] = anova1(log_data(i, :), groups_cell,displayopt);
    if num_of_groups>2
        [mc_table1,~,~,gnames]= multcompare(st,'Display','off');
        mc_fold_change_and_pval(i,1:2:end)=cellfun(@(x)num2str(x,3),num2cell(2.^mc_table1(:,4)),'uniformoutput',false);
        mc_fold_change_and_pval(i,2:2:end)=cellfun(@(x)num2str(x,2),num2cell(mc_table1(:,6)),'uniformoutput',false);
    end
end
[~, ind_sorted] = sort(anova_p);
Q_vec = ones(size(anova_p));
Q_vec(ind_sorted) = get_FDR_param(anova_p(ind_sorted))';

if num_of_groups>2
    for i=1:size(mc_table1,1)
        mc_table1_title{i*2-1}=[gnames{mc_table1(i,1)} '/' gnames{mc_table1(i,2)}];
        mc_table1_title{i*2}='p-val';
    end
end


