function [im1234]=merg2x2well(sub_pics)
% tic
% im1-upper left, im2-upper right, im3-lower left, im4 lower right. all
% uint16 format grayscale images.
% rang1 = the search range in the major overlap direction
% rang2 = the search range in the minor overlap direction
% jump = the steps for the search matrix (to save time) then being
% interpolated
% output im1234 is a uint16 image of the merge images 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
% adjust the levels and force the histogram of each image to be the same
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

[n,m]=size(sub_pics{1,1});

whole_pic=uint16(nan(n*size(sub_pics,1),m*size(sub_pics,2)));
whole_pic_after_adjust=whole_pic;

for i=1:size(sub_pics,1)
    for j=1:size(sub_pics,2)
        whole_pic(n*(i-1)+1:n*i,m*(j-1)+1:m*j)=sub_pics{i,j};
        %         sub_pics{i,j}=imadjust(sub_pics{i,j});
        low1=prctile(sub_pics{i,j}(:),1);
        high1=max(sub_pics{i,j}(:));
        %sub_pics{i,j}=imadjust(sub_pics{i,j}, double([low1,high1])/2^16,[0,0.95]);
        %whole_pic_after_adjust(n*(i-1)+1:n*i,m*(j-1)+1:m*j)=sub_pics{i,j};
    end
end

im1234=imadjust(whole_pic);
% return;
%h = fspecial('gaussian',[30,30],5);
% h = fspecial('gaussian',[10 10],2);

%h = fspecial('average');
%h = fspecial('motion', 50, 45);
%whole_pic_after_adjust_filt=filter2(h,whole_pic_after_adjust);
%whole_pic_after_adjust_filt=imfilter(whole_pic_after_adjust,h,'replicate');
% whole_pic_after_adjust_filt=imfilter(whole_pic,h,'replicate');


% figure; imshow(imadjust(whole_pic_after_adjust_filt))

% figure, imshow(adapthisteq(whole_pic));
% title('Adjust after Merge');

%im1234=whole_pic_after_adjust;
return;
% title('Adjust before Merge');


% im2 = histeq((im2),imhist((im1)));
% im3 = histeq((im3),imhist((im1)));
% im4 = histeq((im4),imhist((im1)));

% % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

% first merge the two left and 2 right images
verrang=rang1;
horrang=rang2;
v_verrang=1:jump:verrang;
v_horrang=-horrang:jump:horrang;

er13=zeros(length(v_verrang),length(v_horrang));
er24=zeros(length(v_verrang),length(v_horrang));

s1=zeros(length(v_verrang),1);
s2=zeros(length(v_verrang),1);
ii=0;
jj=0;
for i=v_verrang
    ii=ii+1;
    tmp1=im1(n-i+1:n,horrang+1:m-horrang);
    s1(ii)=(std(tmp1(:)));
    tmp1=im2(n-i+1:n,horrang+1:m-horrang);
    s2(ii)=(std(tmp1(:)));
    for j=v_horrang
        jj=jj+1;
        tmp=(im1(n-i+1:n,horrang+1:m-horrang) - im3(1:i,horrang-j+1:m-j-horrang));
        er13(ii,jj)=mean(abs(tmp(:)));
        tmp=(im2(n-i+1:n,horrang+1:m-horrang) - im4(1:i,horrang-j+1:m-j-horrang));
        er24(ii,jj)=mean(abs(tmp(:)));
    end
    jj=0;
end
er13=er13./repmat(s1,1,length(v_horrang));
er24=er24./repmat(s2,1,length(v_horrang));

v_verrang_i=1:1:verrang;
v_horrang_i=-horrang:1:horrang;
er13=interp2(v_horrang,v_verrang,er13,v_horrang_i,v_verrang_i','spline');
er24=interp2(v_horrang,v_verrang,er24,v_horrang_i,v_verrang_i','spline');


[~,I] = min(er24(:)+er13(:));
[p,k] = ind2sub(size(er13),I);
k=k-horrang-1;
im13 = [im1(1:n-p, max([k+1,1]):min([m,m+k]));
    [repmat([-[0:p-1]/(p-1)+1]',1,m-k).*im1(n-p+1:n, max([k+1,1]):min([m,m+k]))+...
    repmat([[0:p-1]/(p-1)]',1,m-k).*im3(1:p, max([1,-k-1]):min([m,m-k]))];
    im3(p+1:n, max([1,-k-1]):min([m,m-k]))];
im24 = [im2(1:n-p, max([k+1,1]):min([m,m+k]));
    [repmat([-[0:p-1]/(p-1)+1]',1,m-k).*im2(n-p+1:n, max([k+1,1]):min([m,m+k]))+...
    repmat([[0:p-1]/(p-1)]',1,m-k).*im4(1:p, max([1,-k-1]):min([m,m-k]))];
    im4(p+1:n, max([1,-k-1]):min([m,m-k]))];


[n1,m1]=size(im13);
horrang=rang1;
verrang=rang2;
v_horrang=1:jump:horrang;
v_verrang=-verrang:jump:verrang;

er1234=zeros(length(v_horrang),length(v_verrang));
s1=zeros(length(v_verrang),1);
ii=0;
jj=0;
for i=v_horrang
    ii=ii+1;
    tmp1=im13(verrang+1:n1-verrang,m1-i+1:m1);
    s1(ii)=std(tmp1(:));
    for j=v_verrang
        jj=jj+1;
        tmp=(im13(verrang+1:n1-verrang,m1-i+1:m1) - im24(verrang-j+1:n1-j-verrang,1:i));
        er1234(ii,jj)=mean(abs(tmp(:)));
    end
    jj=0;
end
er1234=er1234./repmat(s1,1,length(v_verrang));
v_horrang_i=1:1:horrang;
v_verrang_i=-verrang:1:verrang;
er1234=interp2(v_verrang,v_horrang,er1234,v_verrang_i,v_horrang_i','spline');


[~,I] = min(er1234(:));
[p,k] = ind2sub(size(er1234),I);
k=k-verrang-1;
im1234 = [im13(max([k+1,1]):min([n1,n1+k]), 1:m1-p),...
    [repmat([-[0:p-1]/(p-1)+1],n1+k,1).*im13(max([k+1,1]):min([n1,n1+k]), m1-p+1:m1)+...
    repmat([[0:p-1]/(p-1)],n1+k,1).*im24(max([1,-k+1]):min([n1,n1-k]), 1:p)],...
im24(max([1,-k+1]):min([n1,n1-k]), p+1:m1)];

im1234=uint16(im1234);

[n1,m1]=size(im1234);
nout=2*n-200;
mout=2*m-200;
im1234=im1234(round((n1-nout)/2):round((n1-nout)/2)+nout-1, round((m1-mout)/2):round((m1-mout)/2)+mout-1);
% toc