function error1=main_gap_width_v1(inputfolder,outputfolder,outpufiletype,th_level,st_size,ob_size_th1,ob_size_th2,std4_th,max_width,input_file_type, algorithm, flag_save_images, flag_movie)

% inputfolder - folder from which files are readed
% outputfolder - folder to which files are written
% outpufiletype - can be png or pdf, 1=pdf, 2=png, default 2
% th_level - threshold for the binarization of the image, default 0.3
% st_size - size of the strel element, default 5
% ob_size_th1 - threshold for removing small object, default 100
% ob_size_th2 - threshold for removing remaining objects, default 5000
% std4_th - threshold for identify iregular scratch, default 25
% max_width - width of the window to look for the scratch, default 500

error1='';

dir_files=dir(fullfile(inputfolder,input_file_type)); 
fname=cell(length(dir_files),1);
av_width=zeros(length(fname),1);
font_size=12;

if ~flag_movie
    for i=1:length(dir_files)
        i
        %hf=figure('position',[200,200,1000,900],'color','w','PaperPositionMode','auto','Visible','off');
        if flag_save_images
            hf=figure('Visible','off');
        end
        
        fname{i}=dir_files(i).name;
        
        if strcmp(algorithm,'phase_contrast')
            [av_width(i), error1]=calc_plot_mean_gap_width_phase_contrast(fullfile(inputfolder,dir_files(i).name),th_level,st_size,ob_size_th1,ob_size_th2,std4_th,max_width,font_size, flag_save_images);
        elseif strcmp(algorithm,'fluorescence')
            [av_width(i), error1]=calc_plot_mean_gap_width_fluorescence(fullfile(inputfolder,dir_files(i).name),th_level,st_size,ob_size_th1,ob_size_th2,std4_th,max_width,font_size, flag_save_images);
        end
        if ~isempty(error1)
            return;
        end
        if flag_save_images
            [~,name1]=fileparts(dir_files(i).name);
            if outpufiletype==1
                save2pdf(fullfile(outputfolder,[name1 '_images_result.pdf']),hf,150);
            elseif outpufiletype==2
                %saveas(hf,fullfile(outputfolder,[name1 '_images_result.png']));
                %frame1=getframe(hf);
                cdata = zbuffer_cdata(hf);
                imwrite(cdata,fullfile(outputfolder,[name1 '_images_result.png']));
            end
            delete(hf);
        end
    end
else
    [~,name1, ext]=fileparts(dir_files(1).name);
    idx=find(dir_files(1).name=='_',1,'last');
    name1=name1(1:idx-1);
    for i=1:length(fname)
        idx=find(dir_files(i).name=='_',1,'last');
        fname{i}=[dir_files(i).name(1:idx) num2str(i) ext];
    end
    %obj1 = VideoWriter(fullfile(outputfolder,[name1 '.avi']));
    if flag_save_images
        obj1= avifile(fullfile(outputfolder,[name1 '_out.avi']),'compression','None','fps',5);
    end
    %obj1.FrameRate = 5;
    %open(obj1);
    midgap_start=[];
    for i=1:length(fname)
        i
        if strcmp(algorithm,'phase_contrast')
            [tmp, midgap_start]=calc_middle_frame2_phase_contrast(fullfile(inputfolder,fname{i}),th_level,st_size,ob_size_th1,ob_size_th2,max_width,midgap_start);
        elseif strcmp(algorithm,'fluorescence')
            [tmp, midgap_start]=calc_middle_frame2_fluorescence(fullfile(inputfolder,fname{i}),th_level,st_size,ob_size_th1,ob_size_th2,max_width,midgap_start);
        end
        if i==1
            middle_all_frames=false([size(tmp) length(fname)]);
        end
        middle_all_frames(:,:,i)=tmp;
    end
    
    frame_diff=(middle_all_frames(:,:,1)-middle_all_frames(:,:,end))~=0;
    val_notframe_diff=middle_all_frames(:,:,1);
    val_notframe_diff=val_notframe_diff(~frame_diff);
    [~,im]=max(abs(cumsum(middle_all_frames==1,3)./repmat(sum(middle_all_frames==1,3),[1 1 length(fname)])...
        - cumsum(middle_all_frames==0,3)./repmat(sum(middle_all_frames==0,3),[1 1 length(fname)])),[],3);
    
    for i=1:length(fname)
        tmp=im<=i-1;
        tmp(~frame_diff)=val_notframe_diff;
        middle_all_frames(:,:,i)=bwareaopen(tmp, ob_size_th2);
    end
    
    for i=1:length(fname)
        i
        if flag_save_images
            hf=figure('PaperPositionMode','auto','Visible','off');
        end
        av_width(i)=calc_plot_mean_gap_width_step2_movie_v3(fullfile(inputfolder,fname{i}),std4_th,max_width,font_size,middle_all_frames(:,:,i), midgap_start, flag_save_images);
        if flag_save_images
            if outpufiletype==1
                save2pdf(fullfile(outputfolder,[name1 '_' num2str(i) '_images_result.pdf']),hf,150);
            elseif outpufiletype==2
                %saveas(hf,fullfile(outputfolder,[name1 '_' num2str(i) '_images_result.png']));
                %frame1=getframe(hf);
                cdata = zbuffer_cdata(hf);
                imwrite(cdata,fullfile(outputfolder,[name1 '_' num2str(i) '_images_result.png']));
            end
            %currFrame = getframe(hf);
            %writeVideo(obj1,currFrame);
            obj1=addframe(obj1,hf);
            delete(hf);
        end
    end
    if flag_save_images
        obj1=close(obj1);
    end
end



table=[fname,m2c(av_width)];
saveCellFile(table,fullfile(outputfolder,'results_gap_width.txt'));
















