function varargout = gui_qcma(varargin)
% GUI_QCMA MATLAB code for gui_qcma.fig
%      GUI_QCMA, by itself, creates a new GUI_QCMA or raises the existing
%      singleton*.
%
%      H = GUI_QCMA returns the handle to a new GUI_QCMA or the handle to
%      the existing singleton*.
%
%      GUI_QCMA('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GUI_QCMA.M with the given input arguments.
%
%      GUI_QCMA('Property','Value',...) creates a new GUI_QCMA or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before gui_qcma_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to gui_qcma_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help gui_qcma

% Last Modified by GUIDE v2.5 06-Aug-2012 14:56:23

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @gui_qcma_OpeningFcn, ...
                   'gui_OutputFcn',  @gui_qcma_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before gui_qcma is made visible.
function gui_qcma_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to gui_qcma (see VARARGIN)

% Choose default command line output for gui_qcma
handles.output = hObject;

plot(handles.axes_train,1)
set(gca,'xtick',[]);
set(gca,'ytick',[]);
%axis(handles.axes_train,'off');

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes gui_qcma wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = gui_qcma_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit_th_level_Callback(hObject, eventdata, handles)
% hObject    handle to edit_th_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_th_level as text
%        str2double(get(hObject,'String')) returns contents of edit_th_level as a double


% --- Executes during object creation, after setting all properties.
function edit_th_level_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_th_level (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_st_size_Callback(hObject, eventdata, handles)
% hObject    handle to edit_st_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_st_size as text
%        str2double(get(hObject,'String')) returns contents of edit_st_size as a double


% --- Executes during object creation, after setting all properties.
function edit_st_size_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_st_size (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_ob_size_th1_Callback(hObject, eventdata, handles)
% hObject    handle to edit_ob_size_th1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_ob_size_th1 as text
%        str2double(get(hObject,'String')) returns contents of edit_ob_size_th1 as a double


% --- Executes during object creation, after setting all properties.
function edit_ob_size_th1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_ob_size_th1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_ob_size_th2_Callback(hObject, eventdata, handles)
% hObject    handle to edit_ob_size_th2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_ob_size_th2 as text
%        str2double(get(hObject,'String')) returns contents of edit_ob_size_th2 as a double


% --- Executes during object creation, after setting all properties.
function edit_ob_size_th2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_ob_size_th2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_std4_th_Callback(hObject, eventdata, handles)
% hObject    handle to edit_std4_th (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_std4_th as text
%        str2double(get(hObject,'String')) returns contents of edit_std4_th as a double


% --- Executes during object creation, after setting all properties.
function edit_std4_th_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_std4_th (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_max_width_Callback(hObject, eventdata, handles)
% hObject    handle to edit_max_width (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_max_width as text
%        str2double(get(hObject,'String')) returns contents of edit_max_width as a double


% --- Executes during object creation, after setting all properties.
function edit_max_width_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_max_width (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_input_folder_Callback(hObject, eventdata, handles)
% hObject    handle to edit_input_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_input_folder as text
%        str2double(get(hObject,'String')) returns contents of edit_input_folder as a double


% --- Executes during object creation, after setting all properties.
function edit_input_folder_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_input_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_input_folder.
function pushbutton_input_folder_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_input_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

directory_name = uigetdir('','Select Input Folder');
if directory_name~=0
    set(handles.edit_input_folder,'string',directory_name);
end

function edit_output_folder_Callback(hObject, eventdata, handles)
% hObject    handle to edit_output_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_output_folder as text
%        str2double(get(hObject,'String')) returns contents of edit_output_folder as a double


% --- Executes during object creation, after setting all properties.
function edit_output_folder_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_output_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_output_folder.
function pushbutton_output_folder_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_output_folder (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

directory_name = uigetdir('','Select Output Folder');
if directory_name~=0
    set(handles.edit_output_folder,'string',directory_name);
end


% --- Executes on button press in pushbutton_process_all.
function pushbutton_process_all_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_process_all (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

inputfolder=strtrim(get(handles.edit_input_folder,'string'));
if ~isdir(inputfolder)
    errordlg('Input folder not found','Folder Error','modal');
    return;
end

outputfolder=strtrim(get(handles.edit_output_folder,'string'));
if ~isdir(outputfolder)
    errordlg('Output folder not found','Folder Error','modal');
    return;
end

if get(handles.radiobutton_phase_contrast,'value')
    algorithm='phase_contrast';
elseif get(handles.radiobutton_fluorescence,'value')
    algorithm='fluorescence';
else
    errordlg('You must choose an Algorithm','Algorithm Error','modal');
    return;
end


flag_save_images=~get(handles.checkbox_not_save_images,'value');
flag_movie=get(handles.checkbox_movie,'value');

if get(handles.radiobutton_pdf,'value')
    outpufiletype=1;
else
    outpufiletype=2;
end

if get(handles.radiobutton_tiff,'value')
    input_file_type='*TIFF';
else
    input_file_type='*jpg';
end

files=dir(fullfile(inputfolder,input_file_type));
if isempty(files)
    errordlg(['No ' input_file_type ' files in input folder'],'File Error','modal');
    return;
end

th_level=str2num(get(handles.edit_th_level,'string'));
st_size=str2num(get(handles.edit_st_size,'string'));
ob_size_th1=str2num(get(handles.edit_ob_size_th1,'string'));
ob_size_th2=str2num(get(handles.edit_ob_size_th2,'string'));
std4_th=str2num(get(handles.edit_std4_th,'string'));
max_width=str2num(get(handles.edit_max_width,'string'));


warning('off', 'Images:initSize:adjustingMag');
tic;
error1=main_gap_width_v1(inputfolder,outputfolder,outpufiletype,th_level,st_size,ob_size_th1,ob_size_th2,std4_th,max_width,input_file_type, algorithm, flag_save_images, flag_movie);
toc;

if ~isempty(error1)
    errordlg(error1,'Error','modal');
    return;
end

save_run_params(outputfolder,th_level,st_size,ob_size_th1,ob_size_th2,std4_th,max_width, algorithm, flag_save_images, flag_movie);

msgbox('The results can be viewed on the output folder.','Analysis finished','modal');

function edit_input_file_Callback(hObject, eventdata, handles)
% hObject    handle to edit_input_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_input_file as text
%        str2double(get(hObject,'String')) returns contents of edit_input_file as a double


% --- Executes during object creation, after setting all properties.
function edit_input_file_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_input_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_input_file.
function pushbutton_input_file_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_input_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

files='*.jpg;*.TIFF;*.avi;*.mpg';
workDir=get(handles.edit_input_folder,'string');
if exist(workDir)==7
    files=fullfile(workDir,files);
end
[FileName,PathName] = uigetfile(files, 'Select Input File');
if FileName~=0
    set(handles.edit_input_file,'string',fullfile(PathName,FileName));
end


% --- Executes on button press in pushbutton_run_train.
function pushbutton_run_train_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_run_train (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

inputfile=strtrim(get(handles.edit_input_file,'string'));
if exist(inputfile)~=2
    errordlg('Input file not found','File Error','modal');
    return;
end
if ~strcmpi(inputfile(end-2:end),'jpg') && ~strcmpi(inputfile(end-3:end),'tiff') && ~strcmpi(inputfile(end-2:end),'tif')
    errordlg('Input file should be jpg or tiff','modal');
    return;
end

if get(handles.radiobutton_phase_contrast,'value')
    algorithm='phase_contrast';
elseif get(handles.radiobutton_fluorescence,'value')
    algorithm='fluorescence';
else
    errordlg('You must choose an Algorithm','Algorithm Error','modal');
    return;
end

I=imread(inputfile);



th_level=str2num(get(handles.edit_th_level,'string'));
st_size=str2num(get(handles.edit_st_size,'string'));
ob_size_th1=str2num(get(handles.edit_ob_size_th1,'string'));
ob_size_th2=str2num(get(handles.edit_ob_size_th2,'string'));
std4_th=str2num(get(handles.edit_std4_th,'string'));
max_width=str2num(get(handles.edit_max_width,'string'));
if size(I,2)<max_width
    errordlg(['Input window width is too large - ' num2str(max_width)],'Width Error','modal');
    return;
end

cla(handles.axes_train);
train_gap_width_v1(inputfile,handles.axes_train,th_level,st_size,ob_size_th1,ob_size_th2,std4_th,max_width,algorithm);


% --- Executes on button press in pushbutton_decompose.
function pushbutton_decompose_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_decompose (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

inputfile=strtrim(get(handles.edit_input_file,'string'));
if exist(inputfile)~=2
    errordlg('Input file not found','File Error','modal');
    return;
end

if ~strcmpi(inputfile(end-2:end),'avi') && ~strcmpi(inputfile(end-2:end),'mpg')
    errordlg('Input file should be avi or mpg','File Error','modal');
    return;
end

outputfolder=strtrim(get(handles.edit_output_folder,'string'));
if ~isdir(outputfolder)
    errordlg('Output folder not found','Folder Error','modal');
    return;
end

obj1=VideoReader(inputfile);

[~,name1]=fileparts(inputfile);


for i=1:obj1.NumberOfFrames
    image1=read(obj1,i);
    if ndims(image1)==3
        image1=rgb2gray(image1);
    end
    
    if get(handles.checkbox_transpose,'value');
        image1=image1';
    end
    
    imwrite(image1,fullfile(outputfolder,[name1 '_' num2str(i) '.jpg']));
end


msgbox('The decomposed images can be viewed on the output folder.','Decomposition finished','modal');


% --- Executes on button press in checkbox_transpose.
function checkbox_transpose_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_transpose (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_transpose


% --- Executes on button press in checkbox_movie.
function checkbox_movie_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_movie (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_movie


% --- Executes when selected object is changed in uipanel_algorithm.
function uipanel_algorithm_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in uipanel_algorithm 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)

if get(handles.radiobutton_phase_contrast,'value')
    set(handles.edit_th_level,'string','0.7');
    msgbox('Binarization threshold was set to 0.7.','Threshold set','modal');
elseif get(handles.radiobutton_fluorescence,'value')
    set(handles.edit_th_level,'string','0.35');
    msgbox('Binarization threshold was set to 0.35.','Threshold set','modal');
end


% --- Executes on button press in checkbox_not_save_images.
function checkbox_not_save_images_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_not_save_images (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_not_save_images
