library('R.methodsS3',lib.loc="R/win-library/3.0")
library('R.oo',lib.loc="R/win-library/3.0")
library('R.matlab',lib.loc="R/win-library/3.0")
mat_input <- readMat("input_for_R.mat")

source("pathifier.R")


library('princurve',lib.loc="R/win-library/3.0")


mat_input$genes<-trim(mat_input$genes)
mat_input$pathwaynames<-as.list(trim(mat_input$pathwaynames))
mat_input$attempts<-c(mat_input$attempts)
mat_input$minexp<-c(mat_input$minexp)
mat_input$minstd<-c(mat_input$minstd)



if (mat_input$numofcpus>1) {
	print(paste("parallel: ", mat_input$numofcpus, " CPUs"))
	library("doMC")
	registerDoMC(mat_input$numofcpus)
	parallel_flag<-TRUE
} else { 
	print("serial")
	parallel_flag<-FALSE
}

mat_input$normals <- as.logical(mat_input$normals)
mat_input$maximizestability <- as.logical(mat_input$maximizestability)


PDS<-quantify_pathways_deregulation(mat_input$data, mat_input$genes, mat_input$gs, mat_input$pathwaynames, mat_input$normals, attempts = mat_input$attempts, maximize_stability = mat_input$maximizestability, min_exp=mat_input$minexp, min_std=mat_input$minstd, parallel = parallel_flag)

save(PDS, file=mat_input$outputrfile)

writeMat(mat_input$resultsmatlab,scores=PDS$scores,newmeanstd=PDS$newmeanstd,origmeanstd=PDS$origmeanstd,pathways=PDS$genesinpathway,pathwaysize=PDS$pathwaysize,curves=PDS$curves, curves_order=PDS$curves_order,z=PDS$z,compin=PDS$compin,alpha=PDS$alpha,sucess=PDS$sucess)



