
//  [lat, m((..., seed))] = ising_2d_sweep(lat, ToverJ, sweeps)

#include "mex.h"
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include "mt19937ar.h"


int xyToL (int x, int y, int L)
{
	int l;
	l = y*L + x; 
	return l;
}

void sweep (double lat[], int L, int len, double *w)
{
   int i, site, x, y, neighbs; 
   double p; 

   for (i=0;i<len;i++)
   {
   
	   site = (int)(myrand()*((double)len)); // choosing a site

	   x = site%L; 
	   y = (int)floor((double)site/(double)L); 
	   neighbs = (int)(lat[site]*(lat[xyToL((x+1)%L,y,L)] + lat[xyToL((x+L-1)%L,y,L)] + lat[xyToL(x,(y+1)%L,L)] + lat[xyToL(x,(y+L-1)%L,L)])); 

	   if (neighbs <= 0)
	   {
			lat[site] = lat[site]*-1; 
	   }
	   else
	   {
		   p = myrand(); 
		   if (p < w[neighbs/2-1])
		   {
			   lat[site] = lat[site]*-1; 			   
		   }
	   }
   }
}

void mexFunction(int nlhs, mxArray *plhs[], int nrhs,
                 const mxArray *prhs[])
{
   double *lat, *ToJ, *latOut, *s, *m;
   int L, i, j, len, mnow;
   double bJ,ToverJ;
   double w[2];
   int seed,sweeps; 
   seed=(unsigned)time(NULL);
   init_genrand((unsigned)seed); 

   if (nrhs != 3) { 
	mexErrMsgTxt("Three input arguments required."); 
    } else if (nlhs != 2) {
	mexErrMsgTxt("Two output arguments required."); 
    } 

   L = mxGetN(prhs[0]);
   len = L*L; // this is the length of the lattice array. 
   if (mxGetM(prhs[0]) != L)
   {
	   mexErrMsgTxt("Lattice must be an L x L square."); 
   }
   /* make sure the second input argument is scalar */
	if( !mxIsDouble(prhs[1]) || 
     mxIsComplex(prhs[1]) ||
     mxGetNumberOfElements(prhs[1])!=1 ) {
    mexErrMsgTxt("betaJ must be a scalar.");
	}

   ToJ = mxGetPr(prhs[1]);
   s = mxGetPr(prhs[2]);
   
   ToverJ = ToJ[0];
   sweeps = s[0]; 
   bJ = 1/ToverJ; 
   w[0] = exp(-4*bJ); 
   w[1] = exp(-8*bJ); 

   plhs[0] = mxCreateDoubleMatrix(L,L, mxREAL);
   plhs[1] = mxCreateDoubleMatrix(sweeps,1, mxREAL);

   lat = mxGetPr(prhs[0]);
   latOut = mxGetPr(plhs[0]);
   m = mxGetPr(plhs[1]);
   m[0] = 0; 

   for(i=0;i<sweeps;i++) 
   {
	   sweep(lat, L, len, w);
	   mnow = 0; 
	   for (j=0;j<len;j++) mnow += lat[j];
	   m[i] += (double)mnow/(double)len; 
   }
   //m[0] = m[0] / sweeps; 

   for (i=0; i<len; i++) latOut[i]=lat[i];
}


