// Ising2D.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include<stdlib.h>
#include<time.h>
#include<string.h>
#include "./mt64.h"
#include "./mt19937-64.c"

int main(int argc , char * argv[])
{
    int*  Spin;	  //current spin configuration
    char* endp;
	char outputfile[80]; //output file name
	FILE* output;
	int L,L2,SweepNum;
	double expBJ[10];  //stores exp(-\beta*J*k) for k=0,1,2,3...
	                   //helps avoid using the exponent function, which is quite costly in terms of computer power, at every metropolis step.
	double M=0,T=3,J=1;
	int i,j;

    sprintf(outputfile,"%s",argv[1]);
    output = fopen(outputfile,"w");

	//reading the input variables
	L  = (int) strtod(argv[2],&endp);
	L2 = L*L;
	SweepNum  = (int) strtod(argv[3],&endp);
	T = (double)strtod(argv[4],&endp);
	J = (double)strtod(argv[5],&endp);
	for (int i=0;i<10;i++)
	{		
		expBJ[i]=exp(-i*J/T);
	}

    Spin     = (int*) malloc(sizeof(int)*L2);

	//setting the intial spin configuration
	SetGrid(Spin, L);

	for (i=0;i<SweepNum;i++)
	{
		//perfroming a monte carlo sweep
		for (j=0;j<L2;j++)
		{
			MetropolisStep(Spin,L,L2,expBJ);
		}
		//summing the average magnetization
		M=0;
		for (int j=0;j<L2;j++)
		{
			M+=Spin[j];
		}			
		//printing out the file, for now it plots M(t) at every sweep. 
		fprintf(output, "%lg\t%lg\n",(double)i,M/L2);
		fflush(output);
	}
	free(Spin);
	fclose(output);

	return 0;
}



