function clean_mat = cancelartifactmatrix(tMat1, tMat2, Tp, mat, varargin)
%   cancelartifactmatrix cleans the initial data from known artifacts by 
%   removing their orthogonal projection from the data and the dictionary. In 
%   this implementation, their are two known artifacts, one along the main
%   diagonal (at T1=T2) and one on the two secondary diagonals (at T1=2T2
%   and T2=2T1). In addition, the user can input more artifacts or noise to
%   be removed in varargin

artNum = 2;
tIni = tMat1(1,1);

artifactMat = zeros(length(tMat1)^2,artNum+(nargin-4));
artifactTensor = zeros(length(tMat1),length(tMat1),artNum+(nargin-4));

% Generate marices with the known artifacts
artifactTensor(:,:,1) = exp(-((tMat1-tMat2)/(sqrt(2)*Tp/sqrt(log(2)))).^2).*(-4e-4*(tMat2-2100));
artifactTensor(:,:,2) = (exp(-(((tMat1-tIni)-2*(tMat2-tIni))/(sqrt(2)*Tp/sqrt(log(2)))).^2) + ...
    exp(-((2*(tMat1-tIni)-(tMat2-tIni))/(sqrt(2)*Tp/sqrt(log(2)))).^2));

% Add the artifacts given by the user
for k = 1:(nargin-4)
    artifactTensor(:,:,2+k) = varargin{k};
end

% Reshape tensor into matrix to match the form of the data and dictionary
for i = 1:size(artifactTensor,3)
    artifactMat(:,i) = reshape(artifactTensor(:,:,i),length(tMat1)^2,1);
    artifactMat(:,i) = artifactMat(:,i)/norm(artifactMat(:,i));
end

% Remove projection
P_A = (artifactMat/(artifactMat'*artifactMat))*artifactMat';
clean_mat = (eye(size(P_A)) - P_A)*mat;
end

