function [outputMatrix] = genFIDmatrixinT1plusT2(TVecDbl, dTRatio, ptsBack, numPtsOrg, FVec, FRes, gamma, FFwhm, TFwhm)
%	genFIDmatrixinT1plusT2 creates a 2D matrix with deacaying oscillations in the T1 + T2 direction based on the molecular 
%   lineshape model in the manuscript. This type of matrix is necessary only in the pulse sequence used in the 2D 
%   experiment contains pairs of pulses separated by T1 + T2
    FIDmatrixinT2Even = genFIDmatrixinT2(TVecDbl, dTRatio, ptsBack, FVec, FRes, gamma, FFwhm, TFwhm, 0);
    FIDvecEven = FIDmatrixinT2Even(:,1);
    FIDmatrixinT2Odd = genFIDmatrixinT2(TVecDbl, dTRatio, ptsBack + 1, FVec, FRes, gamma, FFwhm, TFwhm, 0);
    FIDvecOdd = FIDmatrixinT2Odd(:,1);
    
    countO = 1;
    countE = 1;
    outputMatrix = zeros(numPtsOrg);
    for k=-(numPtsOrg-1):(numPtsOrg-1)
        if rem(k,2)
        currVal = FIDvecOdd(countO);
        currMat = diag(currVal*ones(length(diag(outputMatrix,k)),1),k);
        outputMatrix = outputMatrix + currMat;
        countO = countO + 1;
        else
        currVal = FIDvecEven(countE);
        currMat = diag(currVal*ones(length(diag(outputMatrix,k)),1),k);
        outputMatrix = outputMatrix + currMat;
        countE = countE + 1;
        end
    end
    outputMatrix = flipud(outputMatrix);
end
