% gencrossterms creates terms that represnt the cross-peaks according to the frequencies chosen by BOMP from the
% block-dictionary. The same FID used in the dictionaries is used here.
% Each vector is a 2D matrix of size: length(TVec)^2 x length(TVec)^2 , reshaped to a vector of length: length(TVec)^2

function termsMat = gencrossterms(TVec, gamma, FFwhm, TFwhm, selectedFs, phi1, phi2)
TIni = TVec(1);
dTOrg = TVec(2)-TVec(1);

TLast = 2*TVec(end);
DT = 1;
ptsBack = floor(TIni/DT);
T0 = TIni - ptsBack*DT;
TVecDbl = T0:DT:TLast;
TSpan = (length(TVecDbl)-1)*DT;
dF = 1/TSpan;
numPts = length(TVecDbl);
FMax = numPts/2*dF;
FVec = 0:dF:FMax;

dTRatio = int32(dTOrg/DT);

termsMat = zeros(length(TVec)^2,(length(selectedFs)^2-length(selectedFs))/2);

count = 0;
for i = 1:length(selectedFs)
    for j = i+1:length(selectedFs) % The j fequency is always the larger one
        count = count + 1;
        termMat = ...(1-exp(-((t_mat_1-t_mat_2)/(Tp/sqrt(log(2)))).^2)).*...
            genFIDmatrixinT2(TVecDbl, dTRatio, ptsBack, FVec, selectedFs(i), gamma, FFwhm, TFwhm, phi1).*...
            genFIDmatrixinT1(TVecDbl, dTRatio, ptsBack, FVec, selectedFs(j), gamma, FFwhm, TFwhm, phi2)+...
            genFIDmatrixinT2(TVecDbl, dTRatio, ptsBack, FVec, selectedFs(j), gamma, FFwhm, TFwhm, phi2).*...
            genFIDmatrixinT1(TVecDbl, dTRatio, ptsBack, FVec, selectedFs(i), gamma, FFwhm, TFwhm, phi1);
        termsMat(:,count) = reshape(termMat,length(TVec)^2,1);
        termsMat(:,count) = termsMat(:,count)/sqrt(sum(abs(termsMat(:,count)).^2));
        
    end
end
end

