% gendiagonaldictionary creates a dictionary with all the terms that oscillate in the
% T1 - T2 direction (and T1 + T2 direction if necessary). The paramter varying 
% between columns is the frequency of the molecular line, though the option to
% vary gamma, the linewidth, is already implemented in this code as well.
% the lineshape is based on genFIDmatrixinT1/T2.
% Each vector is a 2D matrix of size: length(TVec)^2 x length(TVec)^2 , reshaped to a vector of length: length(TVec)^2

function dictionary = gendiagonaldictionary(TVec, gamma, FFwhm, Tp, TFwhm, highestOvertone)

[tMat1,tMat2] = meshgrid(TVec,TVec);
TIni = TVec(1);
dTOrg = TVec(2)-TVec(1);
numPtsOrg = length(TVec);
TSpanOrg = (numPtsOrg - 1)*dTOrg;
dFOrg = 1/TSpanOrg;
FMaxOrg = numPtsOrg/2*dFOrg;
FVecBOMP = dFOrg/10:dFOrg/10:FMaxOrg;

TLast = 2*TVec(end);
DT = 1;
ptsBack = floor(TIni/DT);
T0 = TIni - ptsBack*DT;
TVecDbl = T0:DT:TLast;
TSpan = (length(TVecDbl)-1)*DT;
dF = 1/TSpan;
numPts = length(TVecDbl);
FMax = numPts/2*dF;
FVec = 0:dF:FMax;

dTRatio = int32(dTOrg/DT);

dictionary = zeros(length(TVec)^2,(length(FVecBOMP)*length(gamma)*highestOvertone));
count = 0;
for k = 1:length(FVecBOMP)
    for m = 1:length(gamma)
        for l = 1:highestOvertone
            if l == 1
                count = count + 1;
                h = l;
                dictMat = exp(-((tMat1-tMat2)/(Tp/sqrt(log(2)))).^2).*-(tMat2-2100).* ...
                    genFIDmatrixinT1plusT2(TVecDbl, dTRatio, ptsBack, numPtsOrg, ...
                    FVec/h, FVecBOMP(k), gamma(m), FFwhm, TFwhm);
            elseif l < 5 % Correlation of w with DC
                h = l - 1;
                count = count + 1;
                dictMat = (1-exp(-((tMat1-tMat2)/(Tp/sqrt(log(2)))).^2)).*...
                    (genFIDmatrixinT1minusT2(TVecDbl, dTRatio, ...
                    numPtsOrg, FVec/h, FVecBOMP(k), gamma(m)*h, FFwhm, TFwhm, 0));
            end
            dictionary(:,count) = reshape(dictMat,length(TVec)^2,1);
            dictionary(:,count) = dictionary(:,count)/sqrt(sum(abs(dictionary(:,count)).^2));
        end
    end
end
end

