% gendictionary creates a dictionary where the paramter varying between
% columns is the frequency of the molecular line, though the option to
% vary gamma, the linewidth, is already implemented in this code as well.
% the lineshape is based on genFIDmatrixinT1/T2.
% Each vector is a 2D matrix of size: length(TVec)^2 x length(TVec)^2 , reshaped to a vector of length: length(TVec)^2
function [dictionary, FVecBOMP, FVecOrg] = gendictionary(TVec, gamma, FFwhm, Tp, TFwhm, highestOvertone, phi)

[TMat1,TMat2] = meshgrid(TVec,TVec);
TIni = TVec(1);
dTOrg = TVec(2)-TVec(1);
numPtsOrg = length(TVec);
TSpanOrg = (numPtsOrg - 1)*dTOrg;
dFOrg = 1/TSpanOrg;
FMaxOrg = numPtsOrg/2*dFOrg;
FVecOrg = 0:dFOrg:FMaxOrg;
FVecBOMP = dFOrg/10:dFOrg/10:FMaxOrg;

TLast = 2*TVec(end);
DT = 1;
ptsBack = floor(TIni/DT);
T0 = TIni - ptsBack*DT;
TVecDbl = T0:DT:TLast;
TSpan = (length(TVecDbl)-1)*DT;
dF = 1/TSpan;
numPts = length(TVecDbl);
FMax = numPts/2*dF;
FVec = 0:dF:FMax;

dTRatio = int32(dTOrg/DT);

dictionary = zeros(length(TVec)^2,(length(FVecBOMP)*length(gamma)*highestOvertone));
count = 0;
for k = 1:length(FVecBOMP)
    for m = 1:length(gamma)
        for l = 1:highestOvertone
            if l < 3 % Correlation of w and 2w with DC
                count = count + 1;
                h = l;
                dictMat = (1-exp(-((TMat1-TMat2)/(Tp/sqrt(log(2)))).^2)).*...
                    (genFIDmatrixinT2(TVecDbl, dTRatio, ptsBack, FVec/h, FVecBOMP(k), gamma(m), FFwhm, TFwhm, phi)+ ...
                    genFIDmatrixinT1(TVecDbl, dTRatio, ptsBack, FVec/h, FVecBOMP(k), gamma(m), FFwhm, TFwhm, phi));
            elseif l < 7
                if l == 6 % Correlation of w with w/2 (first undertone)
                    h = 0.5;
                else
                    h = l - 2; % Correlation of w with w,2w,3w
                end
                count = count + 1;
                dictMat = (1-exp(-((TMat1-TMat2)/(Tp/sqrt(log(2)))).^2)).*...
                    (genFIDmatrixinT1(TVecDbl, dTRatio, ptsBack, FVec/h, FVecBOMP(k), gamma(m), FFwhm, TFwhm, phi).* ...
                    genFIDmatrixinT2(TVecDbl, dTRatio, ptsBack, FVec, FVecBOMP(k), gamma(m), FFwhm, TFwhm, phi) + ...
                    genFIDmatrixinT1(TVecDbl, dTRatio, ptsBack, FVec, FVecBOMP(k), gamma(m), FFwhm, TFwhm, phi).* ...
                    genFIDmatrixinT2(TVecDbl, dTRatio, ptsBack, FVec/h, FVecBOMP(k), gamma(m), FFwhm, TFwhm, phi));
            else % Correlation of 2w, 3w and w/2 with themselves
                h = l - 5;
                count = count + 1;
                dictMat = (1-exp(-((TMat1-TMat2)/(Tp/sqrt(log(2)))).^2)).*...
                    (genFIDmatrixinT1(TVecDbl, dTRatio, ptsBack, FVec/h, FVecBOMP(k), gamma(m), FFwhm, TFwhm, phi).* ...
                    genFIDmatrixinT2(TVecDbl, dTRatio, ptsBack, FVec/h, FVecBOMP(k), gamma(m), FFwhm, TFwhm, phi));
            end
            dictionary(:,count) = reshape(dictMat,length(TVec)^2,1);
            dictionary(:,count) = dictionary(:,count)/sqrt(sum(abs(dictionary(:,count)).^2));
        end
    end
end
end

