function [outputMatrix] = genFIDmatrixinT1(TVecDbl, dTRatio, ptsBack, FVec, FRes, gamma, FFwhm, TFwhm, phi)
%	genFIDmatrixinT1 creates a 2D matrix with deacaying oscillations (Free Induction Decay) in T1
%   direction based on the molecular lineshape model in the manuscript

inhomogLineShape = -1i*1./(FVec.^2 - FRes^2 - 2*1i*FVec*gamma); % Molecular line shape

cosPhi = cos(phi);
sinPhi = sin(phi);
inhomogLineShape = (cosPhi*real(inhomogLineShape)-sinPhi*imag(inhomogLineShape)) + ...
    1i*(+sinPhi*real(inhomogLineShape)+cosPhi*imag(inhomogLineShape)); % Molecular line out-of-phase component

GaussianF = exp(-2*((FVec-FRes)./(FFwhm/sqrt(log(2)))).^2); %
lineShape = inhomogLineShape.*GaussianF;

lineShape = [conj(fliplr(lineShape)),lineShape(2:end)];
ifftLineShape = real(ifftwithshift(lineShape));
GaussianT = exp(-((TVecDbl-TVecDbl(floor(length(TVecDbl)/2)))/(TFwhm/sqrt(log(2)))).^2); % Exp
ifftLineShape = ifftLineShape.*GaussianT.^2;
FIDVecInT1 = ifftLineShape((floor(length(TVecDbl)/2)+ptsBack+1):dTRatio:end);

outputMatrix = repmat(FIDVecInT1,length(FIDVecInT1),1);
end

