function [outputMatrix] = genFIDmatrixinT1minusT2(TVecDbl, dTRatio, numPtsOrg, FVec, FRes, gamma, FFwhm, TFwhm, phi)
%	genFIDmatrixinT1minusT2 creates a 2D matrix with deacaying oscillations in the T1 - T2 direction based on the molecular
%	lineshape model in the manuscript
    diagNum = numPtsOrg;
    FIDmatrixinT2 = genFIDmatrixinT2(TVecDbl, dTRatio, 0, FVec, FRes, gamma, FFwhm, TFwhm, phi);
    FIDvec = FIDmatrixinT2(:,1);
    
    outputMatrix = zeros(numPtsOrg);
    
    for k=0:(diagNum-1)
        currVal = FIDvec(k+1);
        currMatk = diag(currVal*ones(length(diag(outputMatrix,k)),1),k);
        currMatMinusk = diag(currVal*ones(length(diag(outputMatrix,k)),1),-k);
        outputMatrix = outputMatrix + currMatk + currMatMinusk;
    end
end

