function c = computeNCP(X)
% Computes the normalized cumulative periodogram of an image X.
% Input:    * X - a matrix representing an image.
% Output:   * c - a vector representing the NCP of X.

% Take only principal quarter of FFT2(X):
q1 = floor(size(X,1)/2);
q2 = floor(size(X,2)/2);
X_hat = fft2(X);
P_hat = X_hat(1:q1,1:q2);

% Vectorize FFT2 by increasing spatial frequencies:
[U,V] = meshgrid(1:q1,1:q2);
F = U.^2+V.^2;
[~,Inds] = sort(F(:));
p_hat = P_hat(Inds);

% Compute NCP:
c = cumsum(abs(p_hat(2:end)))./norm(p_hat(2:end),1);