function dataF = filterDataPicardPPS(data,useElliptic)
% Filters data by dropping noise-dominated coefficients from its Fourier
% transform using the Picard parameter.
%   Inputs: * data - the perturbed data (either image or vector) to be
%           filtered.
%           * useElliptic - a boolean flag (either 0 or 1) specifying
%           whether to use elliptic ordering to vectorize the Fourier
%           transform of a 2D image. If useElliptic=1, code uses elliptic
%           ordering, otherwise if useElliptic=0 code uses hyperbolic
%           ordering.
%   Output: * dataF - filtered data.

[p,s] = PPS(data); %decompose as data=p+s where p is periodic and s is smooth.
p_h = fft2(p);

[U,V] = generateShiftedFreqGrid(size(data),[1,1]); %generate frequency grid with zero frequency at (1,1).
if useElliptic
	F = U.^2+V.^2; %elliptic parameterization
else
    F = abs(U.*V); %hyperbolic parametrization
end
f=F(:); 
[~,Inds] = sort(f); %get permutation

b_hat = p_h(Inds); %rearrange coefficients
V_b = flip( cumsum( flip( abs(b_hat).^2 ) ) )./(length(b_hat):-1:1).'; %compute sequence {V(k)}

V_b(V_b==0)=[]; 
h = ceil(length(V_b)/100); %compute step size
difMat = zeros(length(V_b)-h,1);
for jj=1:length(difMat)
    difMat(jj) = abs(V_b(jj+h)-V_b(jj))./V_b(jj);
end
k0 = find(difMat<=1e-2,1); %estimate Picard parameter

b_hat(k0:end)=0; %drop noise-dominated Fourier coefficients
p_h(Inds)=b_hat; %invert permutation
p = ifft2(p_h,'symmetric'); % get filtered periodic component

dataF = p+s; %get filtered data

