function [vals,inds] = findLocalMins(arr)
%Find all local minima of an array of values.
%   * Inputs: * arr - an array of values representing a discrete function.
%   * Outputs: * vals - function values at local minima.
%              * inds - indices of local minima.
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.

vals=[]; inds=[];
for jj=1:length(arr)
    if jj==1
        if arr(jj)<arr(jj+1)
            vals = [vals,arr(jj)]; inds = [inds,jj];
        end
    elseif jj==length(arr)
        if arr(jj)<arr(jj-1)
            vals = [vals,arr(jj)]; inds = [inds,jj];
        end
    elseif arr(jj)<arr(jj-1) && arr(jj)<arr(jj+1)
        vals = [vals,arr(jj)]; inds = [inds,jj];
    end
end
