function [A,b_t,x_t,szO,b] = generateImageExamplesRT(flag,noise)
% Generates image deblurring examples for inversion from the RestoreTools toolbox.
%   Inputs: * flag - example number to use from the following list:
%               1 - satellite
%               2 - GaussianBlur440
%               3 - AtmosphericBlur50
%               4 - Grain
%               5 - Text
%               6 - Text2
%               7 - VariantMotionBlur_large
%           * noise - noise level to add to the clean blurred image such
%           that noise = variance/max(abs(data_clean))^2.
%   Output: * A - coefficient matrix of type psfMatrix.
%           * b_t - vectorized true blurred image (the data).
%           * x_t - vectorized true image (the solution).
%           * szO - original size of image.
%           * b - vectorized perturbed data.

switch flag
    case 1 %satellite
        load satellite %loads PSF, x_true, b
        A = psfMatrix(PSF,'zero');
        x_t = x_true(:);
        b_true = A*x_t;
    case 2 %weird alien
        load('GaussianBlur440','PSF','center','f_true')
        x_true = f_true;
        x_t = x_true(:);
        A = psfMatrix(PSF,center,'zero');
    case 3
        load('AtmosphericBlur50', 'f_true', 'PSF', 'center')
        A = psfMatrix(PSF,center,'zero');
        x_true = f_true;
        x_t = x_true(:);
    case 4
        load Grain
        A = psfMatrix(PSF,'zero');
        x_t = x_true(:);
    case 5
        load Text
        x_true = double(x_true);
        A = psfMatrix(PSF,'zero');
        x_t = x_true(:);
    case 6
        load Text2
        x_true = double(x_true);
        A = psfMatrix(PSF,'zero');
        x_t = x_true(:);
    case 7
        load('VariantMotionBlur_large.mat','f_true','K')
        A = K;
        PSF=[];
        x_true = f_true;
        x_t = x_true(:);
        
        
end
b_t = A*x_t;
szO = size(x_true);
b = b_t + sqrt(noise)*max(abs(b_t))*randn(size(b_t));

L = speye(size(A));