function [fval,argmin] = findGlobalMinV1(arr,f,plotF)
% This function is meant to reliably find global minimum of a 1D function.
% First, it evaluates the function over an initial grid given by arr. Next,
% it uses the solver fminbnd to search for the minimum of the function in a
% restricted interval about each local minima found on the initial grid.
% Finally, it chooses the global minumum among all found local ones.
%   Inputs: * arr - a vector representing inital grid on which the function
%               will be evaluated. It should be dense enough to capture the more
%               pronounced local minima but sparse enough to not significantly impede
%               computation speed.
%           * f - a function receiving a value x and returning the value of
%               the function to be minimize f(x).
%   Outputs: * fval - the found minimum value of the function f
%            * argmin - the value of x producing minimum of f(x).
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.

%Evaluate input function over initial grid:
fArr = zeros(length(arr),1);
for ii=1:length(arr)
    fArr(ii) = f(arr(ii));
end
if plotF
    figure,loglog(arr,fArr)
end
[~,inds] = findLocalMins(fArr); %get all indices of local minima
alphaM = zeros(length(inds),1);
Mk = alphaM;

for ii = 1:length(inds)
    [alphaM(ii),Mk(ii)]=fminbnd(f,arr(max(inds(ii)-1,1)),arr(min(inds(ii)+1,length(arr))),optimset('TolX',1e-9));
end
%save minimum:
argmin = alphaM(Mk==min(Mk));
fval = min(Mk);