function [MSD_h,MSD_e,MSD_LC,MSD_NCP,MSD_PLS,MSD_tikh] = lsqrWithFFTandGKB(A,b,x_t,szO,tol,n0)

% Uses Golub-Kahan bidiagonalization (GKB) to invert an ill-posed problem
% Ax=b using different stopping criteria and both with and without regularizing
% the projected problem.
%   Inputs: * A - the coefficient matrix, given either as a numerical array
%           or as an object with overloaded multiplication (*) and
%           conjugate-transpose (') operators so that the multiplications A*x and
%           A'*x are defined.
%           * b - the perturbed data vector. If the data is a
%           two-dimensional image, it should be vectorized as b(:).
%           * x_t - the vector of the true solution.
%           * szO - size of the original data. (If the data is an image of
%           size M x N, szO = [M,N]. If original data is a vector of length
%           m, szO = [m,1].)
%           * tol - bound on the relative change of the distance between
%           the filtered data and the data reconstructed from the solution
%           used for the DF stopping criterion.
%           * n0 - number of consecutive iterations needed for the
%           different stopping criteria to hold for the iterations to
%           terminate.
%   Output: * MSD_h - MSD obtained with the DF method with vectorization of
%           2D DFT done using hyperbolic ordering.
%           * MSD_e - MSD obtained with the DF method with vectorization of
%           2D DFT done using elliptic ordering.
%           * MSD_LC - MSD obtaine with the L-curve stopping criterion
%           * MSD_NCP - MSD obtained with the NCP method.
%           * MSD_PLS - minimum MSD obtainable for the projected
%           least-squares problem (PLS).
%           * MSD_tikh - minimum MSD obtainable for the projected Tikhonov
%           problem.
totsure=tic;
b_t_e = filterDataPicardPPS(reshape(b,szO),1); b_t_e = b_t_e(:); %filter with elliptic ordering
b_t_h = filterDataPicardPPS(reshape(b,szO),0); b_t_h = b_t_h(:); %filter with hyperbolic ordering
%initialize:
beta = norm(b); u = b/beta;
temp = A'*u; alpha = norm(temp); 
v = temp/alpha;

happy=false;
ii=1;Bk=[];hitCount_fe = 0; hitCount_fh = 0; jfe=[]; jfh=[]; hitCount_ncp = 0; jNCP = []; hitCount_L=0; jL=[];
while ~happy
    % update bidiagonalization:
    temp = A*v(:,ii) - alpha(ii)*u(:,ii);
    temp = temp - u*(u.'*temp);
    beta(ii+1) = norm(temp); u(:,ii+1) = temp/beta(ii+1);
    temp = A'*u(:,ii+1) - beta(ii+1)*v(:,ii);
    temp = temp - v*(v.'*temp);
    alpha(ii+1) = norm(temp); v(:,ii+1) = temp/alpha(ii+1);

    %create or update bidiagonal matrix and projected data vector and true
    %solution:
    if ~isempty(Bk) 
        Bk = [[Bk;zeros(1,size(Bk,2))],[zeros(size(Bk,1)-1,1);alpha(end-1);beta(end)]];
        bk = [bk;0];
        y_t = [y_t; v(:,ii).'*x_t];
    else
        Bk = [alpha(1);beta(2)];
        bk = [norm(b);0];
        y_t = v(:,1:ii).'*x_t;
    end
    y_lsqr = Bk\bk; %invert projected problem
    x{ii} = v(:,1:ii)*y_lsqr; %get projected least-squares solution
    b_rec = A*x{ii}; %get data reconstructed from solution
    MSD(ii) = norm(x_t-x{ii})^2/norm(x_t)^2; %compute MSD at present iteration

    auxArr_e(ii) = norm(b_t_e - b_rec)^2; %distance function for DF method with elliptic ordering
    auxArr_h(ii) = norm(b_t_h - b_rec)^2; %distance function for DF method with hyperbolic ordering
    
%     figure(192),subplot(1,2,1),semilogy(auxArr_c),hold on,semilogy(auxArr_k),hold off
%     subplot(1,2,2),semilogy(MSD),drawnow
    
    rho(ii) = norm(b-b_rec); %residual norm
    eta(ii) = norm(x{ii}); %solution norm
    if ii>=4
        jcL(ii-3) = l_corner(rho,eta); %compute corner of L-curve for projected least-squares problem
    end
    
    c = computeNCP(reshape(b-b_rec,szO)); %compute NCP of residual
    q1q2 = floor(szO(1)/2)*floor(szO(2)/2);
    NCP(ii) = norm((1:q1q2-1).'./(q1q2-1) - c, 1); %compare with straight line
    
    [~,y_lT,~] = solveMSDproblemStandForm(Bk,bk,y_t,logspace(-15,5,1e3),0); %find optimal projected Tikhonov solution
    MSD_tikh(ii) = norm(v(:,1:ii)*y_lT - x_t)^2/norm(x_t)^2; %compute minimum MSD
    
    if ii>1 && (auxArr_e(end-1)-auxArr_e(end))/auxArr_e(end-1)<=tol %check relative change of DF function
        hitCount_fe = hitCount_fe + 1; % if sufficiently low, increment counter
    elseif ii>1 %if not, set counter to zero
        hitCount_fe = 0;
    end
    if  isempty(jfe) && hitCount_fe > n0 %if relative change is small enough for more than n0 consecutive iterations,
        jfe = find(auxArr_e==min(auxArr_e)); %save iteration number at which method terminates
    end
    if ii>1 && (auxArr_h(end-1)-auxArr_h(end))/auxArr_h(end-1)<=tol
        hitCount_fh = hitCount_fh + 1;
    elseif ii>1
        hitCount_fh = 0;
    end
    if  isempty(jfh) && hitCount_fh > n0
        jfh = find(auxArr_h==min(auxArr_h));
    end
    
    if ii>4 && (jcL(end)<=jcL(end-1))
        hitCount_L = hitCount_L + 1;
    elseif ii>4
        hitCount_L = 0;
    end
    if  isempty(jL) && hitCount_L > n0
        jL = jcL(end);
    end
    
    if ii>1 && (NCP(end-1) < NCP(end))
        hitCount_ncp = hitCount_ncp + 1;
    elseif ii>1
        hitCount_ncp = 0;
    end
    if  isempty(jNCP) && hitCount_ncp > n0
        jNCP = find(NCP==min(NCP));
    end
    
    if ii>1 && MSD(end)>MSD(end-1) && ~isempty(jfe) && ~isempty(jfh) && MSD_tikh(end)>MSD_tikh(end-1) && ~isempty(jNCP) && ~isempty(jL)
        break
    end
    ii=ii+1;
end
MSD_e = MSD(jfe);
MSD_h = MSD(jfh);
MSD_LC = MSD(jL);
MSD_NCP = MSD(jNCP);
MSD_PLS = min(MSD);
MSD_tikh = min(MSD_tikh);
toc(totsure)