function [P,S] = PPS(B)
% Decomposes an image B into a sum of a periodic image P and a smooth image
% S known as Periodic-Plus-Smooth (PPS) decomposition.
%   Inputs: * B - the image to be decomposed as B = P+S (can be a vector)
%   Output: * P - the perodic image component
%           * S - the smooth image component

v1 = zeros(size(B)); v2=v1;
v1(1,:) = B(end,:)-B(1,:); v1(end,:) = B(1,:)-B(end,:);
v2(:,1) = B(:,end)-B(:,1); v2(:,end) = B(:,1)-B(:,end);
v = v1+v2;

f1 = repmat(cos(2*pi*(0:size(B,1)-1)./size(B,1)),size(B,2),1).';
f2 = repmat(cos(2*pi*(0:size(B,2)-1)./size(B,2)),size(B,1),1);
ss = fft2(v)./(2*f1+2*f2-4); ss(1)=0; 
S=ifft2(ss,'symmetric');
P = B-S;