function MSDC = compareGKBcriteria(LotNum)
% Compare the DF method with elliptic and hyperbolic ordering with L-curve,
% W-GCV and optimal solutions for regularized and uregularized projected
% problems.
% Inputs:   * LotNum - number of noise realizations to run for each problem
% Outputs:  * MSDC - a 21 x 6 cell array containing MSD values for each
%           problem and noise level such that:
%           MSDC(:,1) - DF method with hyperbolic ordering of DFT
%           MSDC(:,2) - DF method with elliptic ordering of DFT
%           MSDC(:,3) - NCP method for the projected least-squares problem
%           MSDC(:,4) - W-GCV method for projected Tikhonov problem
%           MSDC(:,5) - minimum MSD values for the projected least-squares
%           problem
%           MSDC(:,6) - minimum MSD values for the projected Tikhonov problem

exArr = 1:7;
noiseArr = [1e-2, 1e-4, 1e-6];
MSDC = cell(length(exArr)*length(noiseArr),7);
tol = 2e-3;
n0 = 5;
kji=1;
for ex=exArr
    for noise=noiseArr
        for ii=1:size(MSDC,2), MSDC{kji,ii}=zeros(LotNum,1); end %initialize dimensions and size
        for jj=1:LotNum
            [A,b_t,x_t,szO,b] = generateImageExamplesRT(ex,noise);
            [MSDC{kji,1}(jj),MSDC{kji,2}(jj),MSDC{kji,3}(jj),MSDC{kji,4}(jj),MSDC{kji,6}(jj),MSDC{kji,7}(jj)]...
                = lsqrWithFFTandGKB(A,b,x_t,szO,tol,n0);
            x_wgcv = modified_HyBR(A,b,[],HyBRset('Reorth','on'),1); 
            MSDC{kji,4}(jj) = norm(x_wgcv-x_t)^2/norm(x_t)^2;
            
        end
        kji = kji+1;
    end
end