function generateBoxplotsGKB(MSDC)
% generate boxplots to compare different stopping criteria for Golub-Kahan
% bidiagonalization.
% Inputs:   * MSDC - a cell array with MSD values for each of several methods.
% Should be an output from the 'compareGKBcriteria' function.
% Note that this creates a single figure with up to 4 x 3 subplots. If more
% are required, method should be run multiple times.

numberOfXTicks = 3;
positions = {[0.0826 0.2034],[0.2428 0.2034],[0.4106 0.2034],[0.5785 0.2034],[0.7386 0.2034],[0.9117 0.2034]};
position3 = {[0.1291    0.7817    0.2152    0.1937],...
             [0.4099    0.7817    0.2152    0.1937],...
             [0.6908    0.7817    0.2152    0.1937],...
             [0.1291    0.5626    0.2152    0.1937],...
             [0.4099    0.5626    0.2152    0.1937],...
             [0.6908    0.5626    0.2152    0.1937],...
             [0.1291    0.3434    0.2152    0.1937],...
             [0.4099    0.3434    0.2152    0.1937],...
             [0.6908    0.3434    0.2152    0.1937],...
             [0.1291    0.1242    0.2152    0.1937],...
             [0.4099    0.1242    0.2152    0.1937],...
             [0.6908    0.1242    0.2152    0.1937]};
hh2=figure,
d1 = .04;
d2 = .062;
methods = {'DF$_h$','DF$_e$','L-curve','NCP','W-GCV','PLS$_{opt}$','Tikh$_{opt}$'};
noiseArr = [1e-2,1e-4,1e-6];
for ii=1:size(MSDC,1)
        hh = subplot(4,3,ii),h=boxplot(cell2mat(MSDC(ii,:,1)));
        set(hh,'position',position3{ii})
        if ii>(size(MSDC,1)-3)
            set( gca, 'XTickLabel', methods )
            set(gca,'XTickLabelRotation',90,'FontSize',16)
        else
            set(gca,'XTickLabel',{' '})
        end
        if (mod(ii-1,3)+1 == 1)
            ylabel('MSD','FontSize',16)
        end
        warning('off','MATLAB:Axes:NegativeLimitsInLogAxis')
        set(gca,'yscale','log','fontsize',11)
        set(gca,'Ytick',logspace(log10(min(min(cell2mat(MSDC(ii,:,1))))),log10(max(max(cell2mat(MSDC(ii,:,1))))),numberOfXTicks))
        set(gca,'Yticklabel',num2str(get(gca,'ytick')','%.3f'))
        
        st = [char(ii+'a'-1)];

        text(0.0429,0.9204,st,'fontsize',16,'units','normalized');
        set(gca,'TickLabelInterpreter','latex')
end
temp =[   402    49   852   900];
set(hh2,'position',temp)
q1 = .0;
q2 = .0;
hAllAxes = findobj(gcf,'type','axes');
p11 = get(hAllAxes,'Position');
for ll = 1:length(p11)
    p11{ll} = p11{ll}/1.0;
    p11{ll}(2) = p11{ll}(2)+q1;
    p11{ll}(1) = p11{ll}(1)+q2;
    set(hAllAxes(ll),'Position',p11{ll})
end