function [lambda,x_l,fm] = solveMSDproblemStandForm(A,b,x_t,lambdaI,plotF)

% tic
[U,S,V] = svd(A); 
n=size(A,2);
q = rank(full(A));
m=size(A,1);
sigma = diag(S); % obtain {\sigma_k} from the diagonal of the appropriate submatrix of S

if isempty(lambdaI)
    lambdaI = logspace(-15,15,1e4); %define the values of lambda over which the function will be initially evaluated
end
beta = U'*b; %compute {u_k^*b}

x_lam = @(l) V(:,1:q)*(sigma(1:q)./(sigma(1:q).^2+l^2).*beta(1:q)); %define Tikhonov solution
f = @(l) norm(x_lam(l)-x_t)^2/norm(x_t)^2;

[fm,lambda]=findGlobalMinV1(lambdaI,f,plotF); %minimize the SS function
if length(lambda)~=1 %if above failed to produce a unique minimum - very rare
    [fm,lambda] = findGlobalMinV2(lambdaI,f);
end
x_l = x_lam(lambda); %save Tikhonov solution corresponding to found lambda
% toc