function [lambda,x_l,fm] = solveGCVproblem(x_lam,beta,gamma,r,q,lambdaArr,plotF)
%Applied the GCV method to a given problem.
%   Inputs: * x_lam - anonymous function returning the regularized solution
%           vector x_lam(lambda) for a value of the regularization
%           parameter lambda
%           * beta - the Fourier coefficients beta=U'*b of the perturbed
%           data with respect to the basis of the matrix U from the GSVD of
%           (A,L) such that A=U*S*inv(Y).
%           * gamma - a vector of the generalized singular values of (A,L).
%           * r = size(L,2) - rank(L).
%           * q = rank(A) + rank(L) - size(L,2).
%           * lambdaArr - array of lambda valuesfor initial sampling of
%           function for minimization.
%           * plotF - set plotF=1 to plot the SS function versus the
%           lambda values in lambdaArr.
%   Outputs: * lambda - the chosen Tikhonov regularization parameter.
%            * x_l - the computed solution vecotr.
%            * fm - the value of the GCV function at its minimum.
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.

tic
m = length(beta);
T = @(l) m-r-q+sum(l^2./(gamma.^2+l^2)); %define trace(I-H)
rho = @(l) l^4*sum(beta(r+1:r+q).^2./((gamma.^2+l^2).^2)) + sum(beta(r+q+1:m).^2); %define squared residual norm
GCV = @(l) rho(l)/(T(l)^2); %define the GCV function

[fm,lambda]=findGlobalMinV1(lambdaArr,GCV,plotF); %minimize GCV
if length(lambda)~=1 %if above failed to produce a unique minimum - very rare
    [fm,lambda] = findGlobalMinV2(lambdaArr,GCV);
end
x_l = x_lam(lambda); %save Tikhonov solution corresponding to found lambda
toc