function [k0,s2] = estPicardParML(beta,r,q)
%Estimate the Picard index and variance of the noise for a given
%problem A*x=b using the Lilliefors test
%   Inputs: * beta - vector of the Fourier coefficients of the data
%           beta=U'*b, where U is the rightmost matrix in the GSVD of A.
%           * r = size(L,2)-rank(L)
%           * q = rank(A)+rank(L)-size(L,2)
%   Outputs: * k0 - the estimated Picard index
%            * s2 - the estimated variance of the noise in b
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.

k0 = r+1; %start at lower bound for the Picard index
m = length(beta);
while lillietest(beta(k0:end),.001)~=0 && k0<r+q+1 %use Lilliefors test with alpha=.001
    k0=k0+1;
end

if k0>=r+q+1 %check if Picard index exceeds upper bound
    k0 = r+q;
    s2=0; %if so, set noise to be zero
else
    s2 = sum(beta(k0:end).^2)./(m-k0+1);
end