function A = generateTomoMatrix1D(mu_0,h,d,px,len,imposeRefBC)
% Generate coefficient matrix for one-dimensional current reconstruction. 
% Inputs:   * mu_0 - permeability of free space. Note that its value
%           determines the units assumed for all other quantitites.
%           * h - height of measurement above the surface of the sample.
%           * d - thickness of the sample
%           * px - length of a pixel
%           * len - length of measurement
%           * imposeRefBC - a boolean option specifying whether to impose
%           reflexive boundary conditions on the solution. Set
%           imposeRefBC=1 if there is string possibility that the current
%           outside the measurement window significantly affects the
%           observed magnetic field. Otherwise, set imposeRefBC=0 to not
%           assume any boundary conditions.
% Outputs:  * A - the coefficient matrix generating a magnetic field from a
%           current density vector.

z = h+d/2;
K = @(y,yp) (mu_0/2/pi)*sign(y-yp).*(acos(px*abs(y-yp)./sqrt(px^2*(y-yp).^2+(z+d/2)^2))-acos(px*abs(y-yp)./sqrt(px^2*(y-yp).^2+(z-d/2)^2)));

if imposeRefBC
    [yp,y] = meshgrid(-len+1:2*len,1:len);
    A_f = K(y,yp);
    A_l = A_f(:,1:size(A_f,2)/3); %matrix of left reflection
    A_c = A_f(:,size(A_f,2)/3+1:2*size(A_f,2)/3); %matrix of window
    A_r = A_f(:,2*size(A_f,2)/3+1:end); %matrix of right reflection
    A = A_c + fliplr(A_l+A_r); %remove fliplr for periodic b.c.
else
    [yp,y] = meshgrid(1:len,1:len);
    A = K(y,yp);
end
