function [lambda,x_l,fm] = solveSSProblem(x_lam,gamma,beta,k0,s2,r,q,lambdaArr,plotF)
%Applied the SS method to a given problem with one of three possible
%algorithms specified by flag for determining the Picard index.
%   Inputs: * x_lam - anonymous function returning the regularized solution
%           vector x_lam(lambda) for a value of the regularization
%           parameter lambda
%           * gamma - a vector of the generalized singular values of (A,L).
%           * beta - the Fourier coefficients beta=U'*b of the perturbed
%           data with respect to the basis of the matrix U from the GSVD of
%           (A,L) such that A=U*S*inv(Y).
%           * k0 - an estimate of the Picard parameter.
%           * s2 - an estimate of the variance of the noise.
%           * r = size(L,2) - rank(L).
%           * q = rank(A) + rank(L) - size(L,2).
%           * lambdaArr - array of lambda valuesfor initial sampling of
%           function for minimization.
%           * plotF - set plotF=1 to plot the SS function versus the
%           lambda values in lambdaArr.
%   Outputs: * lambda - the chosen Tikhonov regularization parameter.
%            * x_l - the computed solution vecotr.
%            * fm - the value of the SS function at its minimum.
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.

tic

rho = @(l) l^4*sum(beta(r+1:r+q).^2./((gamma.^2+l^2).^2)) + sum(beta(r+q+1:end).^2); %define squared residual norm
if k0<r+1 %account for values of k_0 outside of range r < k_0 < r+q+1 in case flag = 3 and approximate T_n accordingly
    T_n = @(l) l^2*sum(beta(r+1:r+q).^2./(gamma(1:q).^2+l^2)) + sum(beta(r+q+1:end).^2);
elseif k0>r+q
    T_n = @(l) l^2*sum(s2./(gamma(1:end).^2+l^2)) + sum(beta(r+q+1:end).^2); 
else
    T_n = @(l) l^2*sum(s2./(gamma(1:k0-1-r).^2+l^2)) + l^2*sum(beta(k0:r+q).^2./(gamma(k0-r:q).^2+l^2)) + sum(beta(r+q+1:end).^2); %define approximate T_n
end
f = @(l) rho(l) - 2*T_n(l); %define the SS function

[fm,lambda]=findGlobalMinV1(lambdaArr,f,plotF); %minimize the SS function
if length(lambda)~=1 %if above failed to produce a unique minimum - very rare
    [fm,lambda] = findGlobalMinV2(lambdaArr,f);
end
x_l = x_lam(lambda); %save Tikhonov solution corresponding to found lambda
toc