function MSDC = CompareMethods(LotNum)
%This function compares the direct and stream function methods on four
%numerical examples and three noise levels. Each example is tested with
%LotNum noise realizations to check the methods for consistency. The result
%is outputted as MSDC, a cell array with elements as LotNum x 1 vectors
%with MSD values produced by the methods.
% Inputs:   * LotNum - number of noise realizations to test for each
%           example to test methods for consistency.
% Outputs:  * MSDC - cell array of MSD values for each method and each
%           parameter-choice method.

%Define basic parameter for problems:
MSDC = cell(12,6); %MSD cell array
mu_0 = 4*pi; h = 1; d = .05; px = [1,1]; kji=1; p=.1; %basic parameters
lambdaArr = logspace(-12,3,1e2); %array of values for regularization parameter
for flag=0:3
    for noise = [1e-2, 1e-4, 1e-6]
        if flag==0 %run first example without boundary conditions
            [JxN,JyN,dataC] = generateExamplesFFT(flag+1,mu_0,h,d,px);
            imposeRefBC=0;
        else
            [JxN,JyN,dataC] = generateExamplesFFT(flag,mu_0,h,d,px);
            imposeRefBC=1;
        end
        
        ns = sqrt(noise)*max(abs(dataC(:)));
        
        for jj=1:LotNum
            tic
            %add noise:
            data = dataC + ns*randn(size(dataC));
            
            [MSDC{kji,1}(jj),MSDC{kji,2}(jj),MSDC{kji,3}(jj),alphaGP,alphaGPP,alphaM] ...
                = reconstructCurrentsFFT_direct_MSD(mu_0,h,d,px,data,lambdaArr,0,imposeRefBC,p,JxN,JyN);
            
            [MSDC{kji,4}(jj),MSDC{kji,5}(jj),MSDC{kji,6}(jj),alphaFG,alphaFGP,alphaFM] ...
                = reconstructCurrentsFFT_stream_MSD(mu_0,h,d,px,data,lambdaArr,0,imposeRefBC,p,JxN,JyN);

            toc
        end
        kji = kji+1;
    end
end