% Script to generate error in DFT estimate of the kernel and the analytical
% expression for it for both the direct and stream function methods.

% flag = 1 : The direct method's kernel for the x-component of the current
% density.
% flag = 2 : The stream function method's kernel.

flag = 2;
d = .05; %thickness of sample

harr = exp(-3:.1:2); %aray of heights at which to compute error
zarr = harr + d/2; % z-component of measurements for the above heights
Narr = [50, 100:100:300]; %array of number of points on grid at which to compute error.
MarkerStyles = {'o','square','diamond','^'}; %markers for plots

if flag == 1
    for N = Narr
        err = [];
        for z = zarr
            umax = N;
            x = -umax:umax;
            [X,Y] = meshgrid(x,x);
%             generate centered kernel in real space:
            K = -Y./((X.^2+Y.^2)+1e-1*(X.^2+Y.^2==0)).*((2*z-d)./sqrt(4*(X.^2+Y.^2)+(2*z-d)^2)-(2*z+d)./sqrt(4*(X.^2+Y.^2)+(2*z+d)^2));
            u = -umax:umax;
            [U,V] = meshgrid(u,u);
            U = U/length(u);
            V = V/length(u);
            Kshifted = [K(umax+1:end,umax+1:end) K(umax+1:end,1:umax);K(1:umax,umax+1:end) K(1:umax,1:umax)];
            K = fft2(Kshifted);
            Kshifted = [K(umax+2:end,umax+2:end) K(umax+2:end,1:umax+1);K(1:umax+1,umax+2:end) K(1:umax+1,1:umax+1)];
            K = imag(Kshifted);
%             generate analytical Fourier-transformed kernel
            FTK = -1i*2*V./(V.^2+U.^2).*exp(-2*pi*z*sqrt(V.^2+U.^2)).*sinh(pi*d*sqrt(V.^2+U.^2));
%             compute MSE between them:
            err = [err sum(sum((K-imag(FTK)).^2))/length(K(:))];
        end
        semilogy(zarr,err,MarkerStyles{Narr==N},'markersize',10,'linewidth',1.5)
        xlabel('Pixels')
        ylabel('MSE')
        grid
        hold on
    end
    
elseif flag == 2
    for N = Narr
        err = [];
        for z = zarr
            umax = N;
            x = -umax:umax;
            [X,Y] = meshgrid(x,x);
%             generate centered kernel in real space:
            K = (2*z^2-X.^2-Y.^2)./(z^2+X.^2+Y.^2).^(5/2);
            u = -umax:umax;
            [U,V] = meshgrid(u,u);
            U = U/length(u);
            V = V/length(u);
            Kshifted = [K(umax+1:end,umax+1:end) K(umax+1:end,1:umax);K(1:umax,umax+1:end) K(1:umax,1:umax)];
            K = fft2(Kshifted);
            Kshifted = [K(umax+2:end,umax+2:end) K(umax+2:end,1:umax+1);K(1:umax+1,umax+2:end) K(1:umax+1,1:umax+1)];
            K = real(Kshifted);
%             generate analytical Fourier-transformed kernel
            FTK = 4*pi^2*sqrt(V.^2+U.^2).*exp(-2*pi*z*sqrt(V.^2+U.^2));
%             compute MSE between them:
            err = [err sum(sum((K-FTK).^2))/length(K(:))];
        end
        semilogy(harr,err,['-' MarkerStyles{[50,100,200,300]==N}],'markersize',8,'linewidth',1.5)
        xlabel('h (\mum)')
        ylabel('MSE')
        grid
        hold on
    end
end
set(gca,'fontsize',18)