function [K1,K2] = TakeDFTOfK1K2(mu_0,h,d,sz,px)
% Generates the Fourier-transformed Biot-Savart integral kernels for currents in x- and
% y-directions for field in z-direction.
%   Inputs: * mu_0 - value of permeability of free space. This value
%               determines the units used throughout.
%           * h - height of measurement above the surface of the sample
%           * d - sample thickness.
%           * sz - vector representing size of the physical space so that
%               sz(1) is number rows and sz(2) is number of columns.
%           * px - vector representing size of each pixel in pre-defined units such that px(1)
%               is size along rows and px(2) is size along the columns.
%   Outputs: * K1,K2 - matrix of Fourier-transformed kernel for x- and
%               y-directed currents, respectively.

[u,v] = generateShiftedFreqGrid(sz,px); %Generate grid in Fourier space with centered zero-frequency.
z = h+d/2; %compute z-coordinate of measurement plane.

%Generate the kernels on the grid:
K1 = -1i*(mu_0/2/pi)*exp(-2*pi*z*sqrt(u.^2+v.^2)).*sinh(pi*d*sqrt(u.^2+v.^2)).*v./(u.^2+v.^2);
K2 = 1i*(mu_0/2/pi)*exp(-2*pi*z*sqrt(u.^2+v.^2)).*sinh(pi*d*sqrt(u.^2+v.^2)).*u./(u.^2+v.^2);

%Get rid of NaN at (1,1) - analytically, it should be zero.
K1(1,1)=0;
K2(1,1)=0;