function K = TakeDFTOfKF(mu_0,h,d,sz,px)
% Generates the Fourier-transformed Biot-Savart integral kernels for currents in x- and
% y-directions for field in z-direction.
%   Inputs: * mu_0 - value of permeability of free space. This value
%               determines the units used throughout.
%           * h - height of measurement above the surface of the sample.
%           * d - sample thickness.
%           * sz - vector representing size of the physical space so that
%               sz(1) is number rows and sz(2) is number of columns.
%           * px - vector representing size of each pixel in pre-defined units such that px(1)
%               is size along rows and px(2) is size along the columns.
%   Outputs: * K - matrix of Fourier-transformed kernel for the stream
%               function g(x,y)

[u,v] = generateShiftedFreqGrid(sz,px); %Generate grid in Fourier space with centered zero-frequency.
z = h+d/2; %compute z-coordinate of measurement plane.

%Generate the kernels on the grid:
K = mu_0*exp(-2*pi*z*sqrt(u.^2+v.^2)).*sinh(sqrt(u.^2 + v.^2).*d*pi);
