function [MSDC,GCVC,hArr,h] = compareMethodsUnknownHeight(LotNum)
% Code for generation of figures showing dependance of MSD of the various
% parameter choice methods on the estimate of the true height. Here, the
% true height is fixed and the MSD is computed for different estimates of
% the height.
% Input:    * LotNum - number of realizations for which to run each example.
% Output:   * MSDC - a cell array containing MSD values computed for each
%           example. Each cell contains a 1 x LotNum array of values.
%           * GCVC - a cell array containing values of the parameter-choice
%           functions for each example and for all height estimates.
%           * hArr - array of estimates for the height.
%           * h - the true height.

hArr = 0:.2:3; %array of estimates of the height

%initialization of arrays:
MSDC = cell(9,6);
GCVC = cell(9,4);

mu_0 = 4*pi; h = 1; d = .05; px = [1,1]; kji=1; p=.1; imposeRefBC=1; %basic parameters
lambdaArr = logspace(-15,3,5e2); %array of values for regularization parameter

for flag=1:3
    for noise = [1e-2, 1e-4, 1e-6]
        [JxN,JyN,dataC] = generateExamplesFFT(flag,mu_0,h,d,px); %generate example
        
        ns = sqrt(noise)*max(abs(dataC(:)));
        
        for jj=1:LotNum
            tic
            %add noise:
            data = dataC + ns*randn(size(dataC));
            
            [MSDC{kji,1},MSDC{kji,2},MSDC{kji,3},GCVC{kji,1},GCVC{kji,2}] ...
                = reconstructCurrentsFFT_direct_MSD_woH(mu_0,d,px,data,imposeRefBC,p,lambdaArr,hArr+d/2,JxN,JyN);
            
            [MSDC{kji,4},MSDC{kji,5},MSDC{kji,6},GCVC{kji,3},GCVC{kji,4}] ...
                = reconstructCurrentsFFT_stream_MSD_woH(mu_0,d,px,data,imposeRefBC,p,lambdaArr,hArr+d/2,JxN,JyN);
            toc
        end
        kji = kji + 1;
    end
end