    function [MSDC,h_tArr] = compareMethodsVariableTrueHeight(LotNum)
% Computes data for figures of MSD vs. variable true height. Here, we vary 
% the true height and assume its value every time is known. We then compute 
% the MSD using various parameter choice methods for each value of the true 
% height.
% Input:    * LotNum - number of realizations for which to run each example.
% Output:   * MSDC - a cell array containing MSD values computed for each
%           example. Each cell contains a 1 x LotNum array of values.
%           * h_tArr - array of heights at which reconstructions are
%           performed.

%Define basic parameter for problems:
h_tArr = .1:.2:5; %array of values for the true height
MSDC = cell(9,6,length(h_tArr)); %MSD cell array

mu_0 = 4*pi; d = .05; px = [1,1]; kji=1; p=.1; imposeRefBC=1;
lambdaArr = logspace(-12,3,1e2); %array of values for Tikhonov regularization parameter

for flag=1:1
    for noise = [1e-2, 1e-4, 1e-6]
        for kk=1:length(h_tArr)
            h = h_tArr(kk); %current value of the true height
            [JxN,JyN,dataC] = generateExamplesFFT(flag,mu_0,h,d,px); %generate example
            
            ns = sqrt(noise)*max(abs(dataC(:)));
            
            for jj=1:LotNum
                tic
                %add noise:
                data = dataC + ns*randn(size(dataC));
                
                [MSDC{kji,1,kk}(jj),MSDC{kji,2,kk}(jj),MSDC{kji,3,kk}(jj),alphaGP,alphaGPP,alphaM] ...
                    = reconstructCurrentsFFT_direct_MSD(mu_0,h,d,px,data,lambdaArr,0,imposeRefBC,p,JxN,JyN);
                
                [MSDC{kji,4,kk}(jj),MSDC{kji,5,kk}(jj),MSDC{kji,6,kk}(jj),alphaFG,alphaFGP,alphaFM] ...
                    = reconstructCurrentsFFT_stream_MSD(mu_0,h,d,px,data,lambdaArr,0,imposeRefBC,p,JxN,JyN);
                
                toc
            end
        end
        kji = kji+1;
    end
end