function s2 = estimateNoiseK0(data)
% Estimate the variance of the noise contained in data using 2D FFT.
%   Inputs: * data - a matrix containing the perturbed data.
%   Outputs: * s2 - the variance of the noise contained in data.

data = [rot90(data,2), flipud(data); fliplr(data), data]; %symmetrize data to avoid DFT artifacts due to non-periodicity
b_hat = fft2(data)/sqrt(numel(data)); %unitary 2D FFT of the data

m = min(ceil(size(b_hat)/2)); %number of concentric rectangles
c1 = round(linspace(1,ceil(size(b_hat,1)/2),m)); % row numbers of the corners of the rectangles 
c2 = round(linspace(1,ceil(size(b_hat,2)/2),m)); % column numbers of the corners of the rectangles 

window = @(jj) b_hat(c1(jj):end-c1(jj)+1,c2(jj):end-c2(jj)+1); % the data inside the window of the jj-th rectangle
winSize = @(jj) (size(data,1)-2*(c1(jj)-1))*(size(data,2)-2*(c2(jj)-1)); % the size of the jj-th rectangle
s2Est = @(jj) sum(sum(abs(window(jj)).^2))/(winSize(jj)); % the estimate of s2 for each rectangle

% figure,imagesc(abs(b_hat));
arr = zeros(m,1); %initialize array for s2 estimates
for jj=1:m
%     rectangle('position',[c2(jj),c1(jj),(size(data,2)-2*(c2(jj)-1)),(size(data,1)-2*(c1(jj)-1))],'EdgeColor','r','LineStyle','--'),drawnow
%     pause(.1)
    arr(jj) = s2Est(jj);
end

% choose s2 corresponding to flattest part in arr:
difMat = abs(diff(log(arr)));
s2 = arr(difMat==min(difMat));