function genPlotsUnknownHeight(MSDC,hArr,h_t)
% Generate plots of MSD vs. estimated height when true height is fixed.
% Inputs:   * MSDC - cell array of MSD values for different methods and
%           examples. Assumed to be output of compareMethodsUnknownHeight routine.
%           * hArr - array of height estimates used in
%           compareMethodsUnknownHeight.
%           * h_t - the true height from compareMethodsUnknownHeight

for jj=1:size(MSDC,1)
    
    figure,
    lineW = 1.2; markSz = 10;
    plot(hArr,MSDC{jj,1},'b-+','LineWidth',lineW,'markersize',markSz),hold on
    plot(hArr,MSDC{jj,2},'b-x','LineWidth',lineW,'markersize',markSz)
    plot(hArr,MSDC{jj,3},'b-o','LineWidth',lineW,'markersize',markSz)
    plot(hArr,MSDC{jj,4},'r-*','LineWidth',lineW,'markersize',markSz)
    plot(hArr,MSDC{jj,5},'r-^','LineWidth',lineW,'markersize',markSz)
    plot(hArr,MSDC{jj,6},'r-square','LineWidth',lineW,'markersize',markSz)
    xlabel('h (\mum)'),ylabel('MSD')
    
    set(gca,'yscale','log')
    y_min = min(min([MSDC{jj,:}]));
    y_max = max(max([MSDC{jj,:}]));
    set(gca,'ylim',[y_min,min(y_max,1)])
    
    plot([h_t,h_t],get(gca,'ylim'),'k:','LineWidth',1.5) %vertical line at true height
    
    legend({'MSD (1)','MSD (2)','MSD (3)','MSD (4)', 'MSD (5)','MSD (6)', 'True height'},'location','best','edgecolor','w')
    set(gca,'xlim',[min(hArr) max(hArr)])
    set(gca,'fontsize',24)
    st = char(find((1:3)==jj)+'a'-1);
    pos = [0.22    0.75    0.05    0.16];
    annotation('textbox',pos,'String',st,'FitBoxToText','on','linestyle','none','fontsize',30)
end