function [JxN,JyN,dataC] = generateExamplesFFT(flag,mu_0,h,d,px)
% Generate one of three examples used for FFT-basedreconstructions with the
% direct and stream function methods.
% Inputs:   * flag - number of example to generate out of three possibilities
%           such that flag = 1,2,3.
%           * mu_0 - value of permeability of free space. This value
%           determines the units used.
%           * h - height of measurement above the surface of the sample.
%           * d - thickness of the sample.
%           * px - vector representing size of each pixel in pre-defined 
%           units such that px(1) is size along rows and px(2) is size along 
%           the columns. If the pixel is square (px(1)=px(2)), px can be a 
%           scalar representing its side length.
% Outputs:  * JxN,JyN - x- and y- components of the true current density.
%           * dataC - clean magnetic field data generated from JxN and JyN.

if isscalar(px) %if pixel is square and px is a scalar
    px = [px,px];
end

switch flag %generate the requested example
    case 1
        load('vort4.mat') %Imports: sqJx, sqJy
        JxN = zeros(size(sqJx)+[60,60]); JyN = JxN;
        JxN(1+10:size(sqJx,1)+10,1+10:size(sqJx,2)+10) = sqJx;
        JyN(1+10:size(sqJy,1)+10,1+10:size(sqJy,2)+10) = sqJy;
        [Kx,Ky] = TakeDFTOfK1K2(mu_0,h+d/2,d,size(JxN),px);
        dataC = ifft2(Kx.*fft2(JxN)+Ky.*fft2(JyN));
    case 2
        load('vort5.mat') %Imports: sqJx, sqJy
        JxN = zeros(size(sqJx)+[60,60]); JyN = JxN;
        JxN(1+30:size(sqJx,1)+30,1+30:size(sqJx,2)+30) = sqJx;
        JyN(1+30:size(sqJy,1)+30,1+30:size(sqJy,2)+30) = sqJy;
        [Kx,Ky] = TakeDFTOfK1K2(mu_0,h+d/2,d,size(JxN),px);
        dataC = ifft2(Kx.*fft2(JxN)+Ky.*fft2(JyN));
        JxN = JxN(112:210,112:210);JyN = JyN(112:210,112:210);
        dataC = dataC(112:210,112:210);
    case 3
        load('vort3.mat') %Imports: sqJx, sqJy
        [Kx,Ky] = TakeDFTOfK1K2(mu_0,h+d/2,d,size(sqJx),px);
        dataC = ifft2(Kx.*fft2(sqJx)+Ky.*fft2(sqJy));
        JxN = sqJx(30:90,5:155);
        JyN = sqJy(30:90,5:155);
        dataC = dataC(30:90,5:155);
    otherwise
        error('Flag must be an integer between 1 and 3')
end