function surfReconstructions(z_t,z_o,z_f,countChar,viewPar)
% Generate surf plots for current densities.
% Inputs: * z_t - magnitude of true current distribution
%         * z_o - magntiude of currents reconstructed by direct method
%         * z_f - magnitude of currents reconstructed by the stream
%         function method
%         * countChar - counter tracking the letters used to annotate
%         figures
%         * viewPar - view angles for surfaces.

lims = [min([min(z_t(:)),min(z_o(:)),min(z_f(:))]) max([max(z_t(:)),max(z_o(:)),max(z_f(:))])]; %compute limits for common colorbar
annotPos = [0.167, 0.65, 0.046, 0.13]; %position of annotation letters

figure,
surf(z_t,'LineStyle',':'),xlim([1 size(z_t,2)]),ylim([1 size(z_t,1)]),zlim(lims)
caxis manual,caxis(lims);
zlabel('$|\mathbf{J}|$','Interpreter','latex')
st = char(countChar+'a'-1);
countChar = countChar+1;
annotation('textbox',annotPos,'String',st,'FitBoxToText','on','linestyle','none','fontsize',30)
set(gca,'fontsize',18,'view',viewPar)

figure,
surf(z_o,'LineStyle',':'),xlim([1 size(z_t,2)]),ylim([1 size(z_t,1)]),zlim(lims)
caxis manual,caxis(lims);
zlabel('$|\mathbf{J}|$','Interpreter','latex')
st = char(countChar+'a'-1);
countChar = countChar+1;
annotation('textbox',annotPos,'String',st,'FitBoxToText','on','linestyle','none','fontsize',30)
set(gca,'fontsize',18,'view',viewPar)

figure,
surf(z_f,'LineStyle',':'),xlim([1 size(z_t,2)]),ylim([1 size(z_t,1)]),zlim(lims)
caxis manual,caxis(lims);
zlabel('$|\mathbf{J}|$','Interpreter','latex')
st = char(countChar+'a'-1);
annotation('textbox',annotPos,'String',st,'FitBoxToText','on','linestyle','none','fontsize',30)
set(gca,'fontsize',18,'view',viewPar)