function lf = calcLap(sz)
% Generates a convolution kernel for the discrete Laplacian assuming
% periodic boundary conditions. 
%   Inputs: * sz - vector representing size of the physical space so that
%               sz(1) is number rows and sz(2) is number of columns.
%   Outputs: * lf - matrix of size sz(1) rows and sz(2) columns
%               representing the discrete laplacian as a convolution kernel. 

lp = [0 1 0;1 -4 1;0 1 0]; %use the laplacian signature
lf = zeros(sz); %scale to size sz and shift zero component to center:
lf(1:2,1:2)=lp(2:3,2:3);
lf(end,1:2)=lp(end,2:3);
lf(1:2,end)=lp(1,2:-1:1);
lf(end,end)=lp(1,1);