function genReconstructFigs
% Generates reconstruction surfaces for three examples for both the direct
% and stream function methods.

mu_0 = 4*pi; h = 1; d = .05; px = [1,1]; p=.1; imposeRefBC=1; %initialize basic parameters
lambdaArr = logspace(-12,3,2e2); %array of values for the regularization parameter
noiseArr = [1e-6,1e-6,1e-6]; %noise level for each example
countChar = 1; %counter for letters used as annotation on figures
viewArr = {[38.5000, 22.0000],[42.5000, 31.6000],[10.1000, 24.4000]}; %view angles for surfaces for each example
for flag=1:3
    [JxN,JyN,dataC] = generateExamplesFFT(flag,mu_0,h,d,px); %generate example
    
    z_t = sqrt(JxN.^2+JyN.^2); %form magnitude of true current density
    noise = noiseArr(flag);
    ns = sqrt(noise)*max(abs(dataC(:)));
    tic
    %add noise:
    data = dataC+ns*randn(size(dataC));
    
    [jxO,jyO] = reconstructCurrentsFFT_direct(mu_0,h+d/2,d,px,data,lambdaArr,0,imposeRefBC,p); %reconstruct with direct method
     
    [jxF,jyF] = reconstructCurrentsFFT_stream(mu_0,h+d/2,d,px,data,lambdaArr,0,imposeRefBC,p); %reconstruct with stream function method
    
    z_o = sqrt(jxO.^2+jyO.^2); %form magnitude of current density
    z_f = sqrt(jxF.^2+jyF.^2);
    
    surfReconstructions(z_t,z_o,z_f,countChar,viewArr{flag}) %generate surface
    countChar = countChar + 3; %increment annotation letter
    toc
end