function [k0,s2] = estPicardParP(beta,r,q,e)
%Estimate the Picard index and variance of the noise for a given
%problem A*x=b using the variance estimation function.
%   Inputs: * beta - vector of the Fourier coefficients of the data
%           beta=U'*b, where U is the rightmost matrix in the GSVD of A.
%           * r = size(L,2)-rank(L)
%           * q = rank(A)+rank(L)-size(L,2)
%           * e - a bound for relative change of the variance function V(k)
%           under which it is assumed to level-off.
%   Outputs: * k0 - the estimated Picard index
%            * s2 - the estimated variance of the noise in b
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.
m = length(beta);
Vk = @(k) sum(abs(beta(k:end)).^2)./(m-k+1);
h = ceil(length(beta)/50);
k0 = r+1;
while abs(Vk(k0+h)-Vk(k0))/Vk(k0)>=e && k0<min(r+q,m-h)
    k0 = k0+1;
end
if k0>=r+q+1 %check if Picard index exceeds upper bound
    k0 = r+q;
    s2=0; %if so, set noise to be zero
else
    s2 = Vk(k0);
end