function [bt,n] = separateData(U,b,r,q,e)
% Separate a given perturbed data b of the form A*x=b into clean data and noise using the
% Picard parameter.
%   Inputs: * U - the right-most matrix in the GSVD of A
%           * b - the perturbed data vector
%           * r = size(L,2)-rank(L)
%           * q = rank(A)+rank(L)-size(L,2)
%           * e - the bound on the levelling-off of V(k) for estimation of
%           Picard parameter.
%   Outputs: * bt - the approximate clean data vector
%            * n - the approximate noise vector
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.

beta = U'*b; %compute {u_k^*b}

[k0,~] = estPicardParP(beta,r,q,e); %estimate Picard index

bt = U(:,1:k0-1)*beta(1:k0-1); %estimate clean data
n=b-bt; %compute the assumed noise as the difference between the perturbed data and the clean data