function [lambda,x_l,fm] = solveDFAproblem(x_lam,beta,gamma,k0,r,q,lambdaArr,plotF)
%Given a problem of the form A*x=b where b contains noise, apply the DFA 
%method by approximating noiseless data bt and compute the Tikhonov 
%solution minimizing ||bt-A*x||^2.
%   Inputs: * x_lam - anonymous function returning the regularized solution
%           vector x_lam(lambda) for a value of the regularization
%           parameter lambda
%           * beta - the Fourier coefficients beta=U'*b of the perturbed
%           data with respect to the basis of the matrix U from the GSVD of
%           (A,L) such that A=U*S*inv(Y).
%           * gamma - a vector of the generalized singular values of (A,L).
%           * k0 - an estimate of the Picard parameter.
%           * r = size(L,2) - rank(L).
%           * q = rank(A) + rank(L) - size(L,2).
%           * lambdaArr - array of lambda valuesfor initial sampling of
%           function for minimization.
%           * plotF - set plotF=1 to plot the SS function versus the
%           lambda values in lambdaArr.
%   Outputs: * lambda - the chosen Tikhonov regularization parameter.
%            * x_l - the computed solution vecotr.
%            * fm - the value of the GCV function at its minimum.
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.

tic
f = @(l) sum(l^4*beta(r+1:k0-1).^2./(gamma(1:k0-1-r).^2+l^2).^2) + sum(gamma(k0-r:end).^4.*beta(k0:r+q).^2./(gamma(k0-r:end).^2+l^2).^2);

[fm,lambda] = findGlobalMinV1(lambdaArr,f,plotF); %minimize norm
if length(lambda)~=1 %if above method failed to find a unique minimum - very rare
    [fm,lambda] = findGlobalMinV2(lambdaArr,PMSE);
end
x_l = x_lam(lambda); %save Tikhonov solution minimizing the above norm
toc