function [lambda,x_l,fm] = solveMSDProblem(x_lam,x_t,lambdaArr,plotF)
% Find the optimal solution by minimizing the MSD =
% ||x_true-x||^2/||x_true||^2.
%   Inputs: * x_lam - anonymous function returning the regularized solution
%           vector x_lam(lambda) for a value of the regularization
%           parameter lambda.
%           * x_t - the vector of the true solution.
%           * lambdaArr - array of lambda valuesfor initial sampling of
%           function for minimization.
%           * plotF - set plotF=1 to plot the SS function versus the
%           lambda values in lambdaArr.
%   Outputs: * lambda - the chosen Tikhonov regularization parameter.
%            * x_l - the computed solution vecotr.
%            * fm - the value of the GCV function at its minimum.
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.

MSD = @(l) norm(x_lam(l)-x_t)^2./norm(x_t)^2;
[fm,lambda] = findGlobalMinV1(lambdaArr,MSD,plotF);
x_l = x_lam(min(lambda));