function [fval,argmin] = findGlobalMinV2(arr,f)
%Find global minimum of a function using the GlobalSearch algorithm.
%   Inputs: * arr - a vector representing inital grid on which the function
%               will be evaluated. It should be dense enough to capture the more
%               pronounced local minima but sparse enough to not significantly impede
%               computation speed.
%           * f - a function receiving a value x and returning the value of
%               the function to be minimize f(x).
%   Outputs: * fval - the found minimum value of the function f
%            * argmin - the value of x producing minimum of f(x).
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.

fArr = zeros(length(arr),1);
for ii=1:length(arr)
    fArr(ii) = f(arr(ii));
end
init = min(arr(fArr==min(fArr)));

problem = createOptimProblem('fmincon','objective',...
 f,'x0',init,'lb',1e-15,'ub',1e15);
gs = GlobalSearch('TolFun',1e-9,'TolX',1e-9);
[argmin,fval] = run(gs,problem);