function FailRate = generateBoxPlots(MSDC)
% Generate boxplots from MSD data generated using the CompareMethods
% routine. This function was used to generate the boxplots presented in the
% paper.
%   Inputs: * MSDC - a cell array containing the MSD values for 
% 
% Eitan Levin, Alexander Meltzer,
% Department of Condensed Matter Physics, 
% Weizmann Institute of Science,
% 2015-16.
MSDC = cellfun(@(a)reshape(a,[],1),MSDC,'UniformOutput',0);
methods = {'(1)','(2)','(3)','(4)','(5)','(6)','(7)','(8)','(9)','(10)'};
FailRate = zeros(size(MSDC,1),length(methods));
for ii=1:size(MSDC,1)
    figure,boxplot(cell2mat(MSDC(ii,:)),'Labels',methods)
    ylabel('MSD')
    warning('off','MATLAB:Axes:NegativeLimitsInLogAxis')
    
    set(gca,'yscale','log','FontSize',18,'TickLabelInterpreter','latex')
    ylim([min(MSDC{ii,1}(:)),1])
    FailRate(ii,:) = cellfun(@(a) sum(a>1),MSDC(ii,:));
%     annotation('textbox',[0.2729,0.0002,0.123,0.0635],'string','SS-PMSE','linestyle','none','fontsize',16)
%     annotation('textbox',[0.508,0.0002,0.123,0.0635],'string','SS-MSE','linestyle','none','fontsize',16)
    annotation('textbox',[0.1583,0.8347,0.0698,0.0608],'string',['(' char(ii+'a'-1) ')'],'linestyle','none','fontsize',20)
    set(gcf,'outerposition', [-5.4000  360.2000  604.0000  504.8000])
end
