% PARAMETERS:
%   ft    - Time period.
%   ts    - The number of time steps.
%   N     - The size of the Chebyshev matrix.
%   err   - Accuracy of the polynomial approximation.
%


 clear all; 
 N=25; 
 ft = 5;     % final time
 % # of time steps
 ts = [500, 1000, 5000, 10000, 50000, 100000, 500000, 1000000, 5000000];  % # of time steps
 harr = ft./ts;  % array of delta t 
 aa = 1000; beta = 1;
 [D,q] = cheb(N); D2 = D^2; D = D2(2:N,2:N);
 x = q(2:N);
 u0 = cos(pi*x/2);  % Initial condition
 
 V1 = 1i*(aa+pi^2/4)*eye(N-1);
 V2 = -1i*beta*diag(cos(pi*q(2:N)/2).^2);
 D = 1i*D;
 L = D+V1+V2; % the linear operator

 for kk = 1:length(ts) % outer loop, simulations with different time step
     h = harr(kk);
     Er = zeros(ts(kk)+1,1);
     u = u0;
     tic
     %initiallization step
     Op1 = h*L/2;
     Op2 = Op1*2;

     R1 = imag(eigs(Op2,1,'si'));
     R2 = imag(eigs(Op2,1,'li'));
     
     Rc2 = (R2-R1)/2;
     Gc2 = -(R2+R1)/2;
     
     % calulation of Chebyshev series coefficients
     c2  = schwarz(Rc2,Gc2,3);

     R1 = R1/2;
     R2 = R2/2;
     Rc1 = (R2-R1)/2;
     Gc1 = -(R2+R1)/2;
     
     % calculation of Chebyshev series coefficients
     c1  = schwarz(Rc1,Gc1,1);
     
     % calculation of the matrix functions
     S1 = NLSloop_type1(h/2,Rc1,Gc1,L,c1);
     S2 = NLSloop_type1(h,Rc2,Gc2,L,c2);
     
     % the main loop
     for k=0:ts(kk)
         
        Nu = h*beta*(1i*conj(u).*u.^2);
        v1 = Op1*u+Nu/2;                             
        a = S1*v1 + u;   

        Na = h*beta*(1i*conj(a).*a.^2);
        v1 = Op1*u+Na/2;                           
        b = S1*v1 + u;   

        Nb = h*beta*(1i*conj(b).*b.^2);
        v1 = Op1*a+(Nb-Nu/2);        
        c = S1*v1 + a;  

        Nc = h*beta*(1i*conj(c).*c.^2);
        v3 = Op2*u+Nu; % v1                                          
        v2 = Op2*v3+(-3*Nu+2*Na+2*Nb-Nc);
        v1 = Op2*v2+4*(Nu-Na-Nb+Nc);
        
        u = S2*v1 + u+v2/2+v3;  

        er = max(max(abs(u-u0*exp(1i*aa*(k+1)*h))));          
        Er(k+1) = er; 
        if er>2 | isnan(er), break, end;
     end

     maxEr = max(Er);
     ttt = toc;
     disp(['h = ' num2str(h) '    error = ' num2str(maxEr)   '   calculation time = ' num2str(ttt) ' R2-R1 = ' num2str((R2-R1)*2)])
 end