function [S] = NLSloop_type1(h,R,G,L,c)

% This function evaluates the matrix function
% h - time step
% R = (R2-R1)/2 Section 4 in the paper
% G =-(R1+R2)/2 Section 4 in the paper
% L - the linear operator 

l = length(c);
len = length(L);
T0 = eye(len);
T1 = -1i/R*(h*(L*T0)+1i*G*T0);
% polynomial sum
S = c(1)*T0 +2*c(2)*T1;

  for j=3:l
     % recurrence relation
     temp1 = L*T1;
     temp2 = 1i*G*T1;
     temp3 = h*temp1+temp2;
     T2 = -2i/R*temp3-T0;
     % polynomial sum
     T0 = T1; T1 = T2;      
     S = S + 2*c(j)*T2;
  end
 
 
 