function v = chebyshev_u(n, x)

% chebyshev_u evaluates Chebyshev polynomials U(n,x).

  if (n < 0)
    v = [];
    return
  end

  v = zeros(1,n+1);
  v(1) = 1;

  if (n < 1)
    return
  end

  v(2) = 2*x;

  for j = 2:n
    v(j+1) = 2*x*v(j) - v(j-1);
  end

  return
end